/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.postgres.PostgresMailboxAnnotationDataDefinition;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.postgres.extensions.types.Hstore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailboxAnnotationDAO {
    private static final char SQL_WILDCARD_CHAR = '%';
    private static final String ANNOTATION_KEY_FIELD_NAME = "annotation_key";
    private static final String ANNOTATION_VALUE_FIELD_NAME = "annotation_value";
    private static final String EMPTY_ANNOTATION_VALUE = null;
    private final PostgresExecutor postgresExecutor;

    public PostgresMailboxAnnotationDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Flux<MailboxAnnotation> getAllAnnotations(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).singleOrEmpty().map(record -> (LinkedHashMap)record.get(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS, LinkedHashMap.class)).flatMapIterable(this::hstoreToAnnotations);
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeys(PostgresMailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select((SelectField)DSL.function((String)"slice", (DataType)DefaultDataType.getDefaultDataType((String)"hstore"), (Field[])new Field[]{PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS, DSL.array((Collection)keys.stream().map(mailboxAnnotationKey -> DSL.val((String)mailboxAnnotationKey.asString())).collect(Collectors.toUnmodifiableList()))})).from(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).singleOrEmpty().map(record -> (LinkedHashMap)record.get(0, LinkedHashMap.class)).flatMapIterable(this::hstoreToAnnotations);
    }

    public Mono<Boolean> exist(PostgresMailboxId mailboxId, MailboxAnnotationKey key) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select((SelectField)DSL.field((String)(" exist(" + PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS.getName() + ",?)"), (Object[])new Object[]{key.asString()})).from(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).singleOrEmpty().map(record -> (Boolean)record.get(0, Boolean.class)).defaultIfEmpty((Object)false);
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeyLike(PostgresMailboxId mailboxId, MailboxAnnotationKey key) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom((TableLike)dslContext.select((SelectField)DSL.field((String)"(each(annotations)).key").as(ANNOTATION_KEY_FIELD_NAME), (SelectField)DSL.field((String)"(each(annotations)).value").as(ANNOTATION_VALUE_FIELD_NAME)).from(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())).asTable()).where((Condition)DSL.field((String)ANNOTATION_KEY_FIELD_NAME).like(key.asString() + "%")))).map(record -> MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey((String)record.get(ANNOTATION_KEY_FIELD_NAME, String.class)), (String)((String)record.get(ANNOTATION_VALUE_FIELD_NAME, String.class))));
    }

    public Mono<Void> insertAnnotation(PostgresMailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME, PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID, PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS).values((Object)mailboxId.asUuid(), (Object)this.annotationAsHstore(mailboxAnnotation)).onConflict(new Field[]{PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID}).doUpdate().set(DSL.field((String)(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS.getName() + "[?]"), (Object[])new Object[]{mailboxAnnotation.getKey().asString()}), (Object)mailboxAnnotation.getValue().orElse(EMPTY_ANNOTATION_VALUE))));
    }

    public Mono<Void> deleteAnnotation(PostgresMailboxId mailboxId, MailboxAnnotationKey key) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.update(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).set(DSL.field((String)PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS.getName()), (Object)DSL.function((String)"delete", (DataType)DefaultDataType.getDefaultDataType((String)"hstore"), (Field[])new Field[]{PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS, DSL.val((String)key.asString())})).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid()))));
    }

    public Mono<Integer> countAnnotations(PostgresMailboxId mailboxId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select((SelectField)DSL.field((String)("array_length(akeys(" + PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.ANNOTATIONS.getName() + "), 1)"))).from(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.TABLE_NAME).where(PostgresMailboxAnnotationDataDefinition.PostgresMailboxAnnotationTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).singleOrEmpty().flatMap(record -> Mono.justOrEmpty((Object)((Integer)record.get(0, Integer.class)))).defaultIfEmpty((Object)0);
    }

    private List<MailboxAnnotation> hstoreToAnnotations(LinkedHashMap<String, String> hstore) {
        return hstore.entrySet().stream().map(entry -> MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }

    private Hstore annotationAsHstore(MailboxAnnotation mailboxAnnotation) {
        return Hstore.hstore((Map)ImmutableMap.of((Object)mailboxAnnotation.getKey().asString(), (Object)((String)mailboxAnnotation.getValue().get())));
    }
}

