/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.Domain;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.StringBackedAttachmentId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentDataDefinition;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresAttachmentDAO {
    private final PostgresExecutor postgresExecutor;
    private final BlobId.Factory blobIdFactory;

    public PostgresAttachmentDAO(PostgresExecutor postgresExecutor, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.blobIdFactory = blobIdFactory;
    }

    public Mono<Pair<AttachmentMetadata, BlobId>> getAttachment(AttachmentId attachmentId) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TYPE, PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID, PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID, PostgresAttachmentDataDefinition.PostgresAttachmentTable.SIZE).from(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME).where(PostgresAttachmentDataDefinition.PostgresAttachmentTable.ID.eq((Object)attachmentId.getId())))).map(row -> Pair.of((Object)AttachmentMetadata.builder().attachmentId(attachmentId).type((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TYPE)).messageId((MessageId)PostgresMessageId.Factory.of((UUID)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID))).size(((Long)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.SIZE)).longValue()).build(), (Object)this.blobIdFactory.parse((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID))));
    }

    public Flux<AttachmentMetadata> getAttachments(Collection<AttachmentId> attachmentIds) {
        if (attachmentIds.isEmpty()) {
            return Flux.empty();
        }
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectFrom(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME).where(PostgresAttachmentDataDefinition.PostgresAttachmentTable.ID.in((Collection)attachmentIds.stream().map(AttachmentId::getId).collect(ImmutableList.toImmutableList()))))).map(row -> AttachmentMetadata.builder().attachmentId((AttachmentId)StringBackedAttachmentId.from((String)((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.ID)))).type((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TYPE)).messageId((MessageId)PostgresMessageId.Factory.of((UUID)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID))).size(((Long)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.SIZE)).longValue()).build());
    }

    public Mono<Void> storeAttachment(AttachmentMetadata attachment, BlobId blobId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME).set(PostgresAttachmentDataDefinition.PostgresAttachmentTable.ID, (Object)attachment.getAttachmentId().getId()).set(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID, (Object)blobId.asString()).set(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TYPE, (Object)attachment.getType().asString()).set(PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID, (Object)((PostgresMessageId)attachment.getMessageId()).asUuid()).set(PostgresAttachmentDataDefinition.PostgresAttachmentTable.SIZE, (Object)attachment.getSize())));
    }

    public Mono<Void> deleteByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME).where(PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID.eq((Object)messageId.asUuid()))));
    }

    public Flux<BlobId> listBlobsByMessageId(PostgresMessageId messageId) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID).from(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME).where(PostgresAttachmentDataDefinition.PostgresAttachmentTable.MESSAGE_ID.eq((Object)messageId.asUuid())))).map(row -> this.blobIdFactory.parse((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID)));
    }

    public Flux<BlobId> listBlobs() {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID).from(PostgresAttachmentDataDefinition.PostgresAttachmentTable.TABLE_NAME))).map(row -> this.blobIdFactory.parse((String)row.get(PostgresAttachmentDataDefinition.PostgresAttachmentTable.BLOB_ID)));
    }

    public static class Factory {
        private final PostgresExecutor.Factory executorFactory;
        private final BlobId.Factory blobIdFactory;

        @Inject
        @Singleton
        public Factory(PostgresExecutor.Factory executorFactory, BlobId.Factory blobIdFactory) {
            this.executorFactory = executorFactory;
            this.blobIdFactory = blobIdFactory;
        }

        public PostgresAttachmentDAO create(Optional<Domain> domain) {
            return new PostgresAttachmentDAO(this.executorFactory.create(domain), this.blobIdFactory);
        }
    }
}

