/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Set;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationAggregate;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.RegisterConfigurationCommand;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.RegisterConfigurationCommandHandler;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EventsourcingConfigurationManagement {
    static final String CONFIGURATION_AGGREGATE_KEY = "CassandraMailQueueViewConfiguration";
    static final AggregateId CONFIGURATION_AGGREGATE_ID = () -> "CassandraMailQueueViewConfiguration";
    private static final ImmutableSet<Subscriber> NO_SUBSCRIBER = ImmutableSet.of();
    private final EventStore eventStore;
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public EventsourcingConfigurationManagement(EventStore eventStore) {
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new RegisterConfigurationCommandHandler(eventStore)), NO_SUBSCRIBER, (EventStore)eventStore);
        this.eventStore = eventStore;
    }

    @VisibleForTesting
    Mono<CassandraMailQueueViewConfiguration> load() {
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate(CONFIGURATION_AGGREGATE_ID)).map(history -> ConfigurationAggregate.load(CONFIGURATION_AGGREGATE_ID, history).getCurrentConfiguration()).handle(ReactorUtils.publishIfPresent());
    }

    public void registerConfiguration(CassandraMailQueueViewConfiguration newConfiguration) {
        Preconditions.checkNotNull((Object)newConfiguration);
        Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new RegisterConfigurationCommand(newConfiguration, CONFIGURATION_AGGREGATE_ID))).block();
    }
}

