/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.postgres;

import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresEventStoreDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresEventStoreTable.TABLE}).addIndex(new PostgresIndex[]{PostgresEventStoreTable.INDEX}).build();

    public static interface PostgresEventStoreTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"event_store");
        public static final Field<String> AGGREGATE_ID = DSL.field((String)"aggregate_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Integer> EVENT_ID = DSL.field((String)"event_id", (DataType)SQLDataType.INTEGER.notNull());
        public static final Field<Integer> SNAPSHOT = DSL.field((String)"snapshot", (DataType)SQLDataType.INTEGER);
        public static final Field<JSON> EVENT = DSL.field((String)"event", (DataType)SQLDataType.JSON.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(AGGREGATE_ID).column(EVENT_ID).column(SNAPSHOT).column(EVENT).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{AGGREGATE_ID, EVENT_ID}))).disableRowLevelSecurity().build();
        public static final PostgresIndex INDEX = PostgresIndex.name((String)"event_store_aggregate_id_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{AGGREGATE_ID}));
    }
}

