/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.AuthenticationDetails;
import com.unboundid.util.json.ConnectionOptions;
import com.unboundid.util.json.ConnectionPoolOptions;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import com.unboundid.util.json.SecurityOptions;
import com.unboundid.util.json.ServerDetails;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPConnectionDetailsJSONSpecification {
    @NotNull
    static final String FIELD_AUTHENTICATION_DETAILS = "authentication-details";
    @NotNull
    static final String FIELD_COMMUNICATION_SECURITY = "communication-security";
    @NotNull
    static final String FIELD_CONNECTION_OPTIONS = "connection-options";
    @NotNull
    static final String FIELD_CONNECTION_POOL_OPTIONS = "connection-pool-options";
    @NotNull
    static final String FIELD_SERVER_DETAILS = "server-details";
    @Nullable
    private final BindRequest bindRequest;
    @NotNull
    private final ConnectionPoolOptions connectionPoolOptionsSpec;
    @NotNull
    private final SecurityOptions securityOptionsSpec;
    @NotNull
    private final ServerSet serverSet;

    public LDAPConnectionDetailsJSONSpecification(@NotNull JSONObject connectionDetailsObject) throws LDAPException {
        ConnectionOptions connectionOptionsSpec;
        LDAPConnectionDetailsJSONSpecification.validateTopLevelFields(connectionDetailsObject);
        try {
            this.securityOptionsSpec = new SecurityOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_COMMUNICATION_SECURITY, le.getMessage()), le);
        }
        try {
            connectionOptionsSpec = new ConnectionOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_CONNECTION_OPTIONS, le.getMessage()), le);
        }
        try {
            ServerDetails serverDetailsSpec = new ServerDetails(connectionDetailsObject, this.securityOptionsSpec, connectionOptionsSpec);
            this.serverSet = serverDetailsSpec.getServerSet();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_SERVER_DETAILS, le.getMessage()), le);
        }
        try {
            AuthenticationDetails authenticationDetailsSpec = new AuthenticationDetails(connectionDetailsObject);
            this.bindRequest = authenticationDetailsSpec.getBindRequest();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_AUTHENTICATION_DETAILS, le.getMessage()), le);
        }
        try {
            this.connectionPoolOptionsSpec = new ConnectionPoolOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_CONNECTION_POOL_OPTIONS, le.getMessage()), le);
        }
    }

    @NotNull
    public static LDAPConnectionDetailsJSONSpecification fromString(@NotNull String jsonString) throws JSONException, LDAPException {
        return new LDAPConnectionDetailsJSONSpecification(new JSONObject(jsonString));
    }

    @NotNull
    public static LDAPConnectionDetailsJSONSpecification fromFile(@NotNull String path) throws IOException, JSONException, LDAPException {
        return LDAPConnectionDetailsJSONSpecification.fromFile(new File(path));
    }

    @NotNull
    public static LDAPConnectionDetailsJSONSpecification fromFile(@NotNull File file) throws IOException, JSONException, LDAPException {
        return LDAPConnectionDetailsJSONSpecification.fromInputStream(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LDAPConnectionDetailsJSONSpecification fromInputStream(@NotNull InputStream inputStream) throws IOException, JSONException, LDAPException {
        try {
            int bytesRead;
            ByteStringBuffer b = new ByteStringBuffer();
            byte[] readBuffer = new byte[8192];
            while ((bytesRead = inputStream.read(readBuffer)) >= 0) {
                b.append(readBuffer, 0, bytesRead);
            }
            LDAPConnectionDetailsJSONSpecification lDAPConnectionDetailsJSONSpecification = new LDAPConnectionDetailsJSONSpecification(new JSONObject(b.toString()));
            return lDAPConnectionDetailsJSONSpecification;
        }
        finally {
            inputStream.close();
        }
    }

    @NotNull
    public ServerSet getServerSet() {
        return this.serverSet;
    }

    @Nullable
    public BindRequest getBindRequest() {
        return this.bindRequest;
    }

    @NotNull
    public LDAPConnection createConnection() throws LDAPException {
        LDAPConnection connection = this.createUnauthenticatedConnection();
        if (this.bindRequest != null) {
            try {
                connection.bind(this.bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        return connection;
    }

    @NotNull
    public LDAPConnection createUnauthenticatedConnection() throws LDAPException {
        return this.serverSet.getConnection();
    }

    @NotNull
    public LDAPConnectionPool createConnectionPool(int initialConnections, int maximumConnections) throws LDAPException {
        LDAPConnectionPool connectionPool = new LDAPConnectionPool(this.serverSet, this.bindRequest, initialConnections, maximumConnections, this.connectionPoolOptionsSpec.getInitialConnectThreads(), this.securityOptionsSpec.getPostConnectProcessor(), false, this.connectionPoolOptionsSpec.getHealthCheck());
        this.connectionPoolOptionsSpec.applyConnectionPoolSettings(connectionPool);
        return connectionPool;
    }

    @NotNull
    public LDAPConnectionPool createUnauthenticatedConnectionPool(int initialConnections, int maximumConnections) throws LDAPException {
        LDAPConnectionPool connectionPool = new LDAPConnectionPool(this.serverSet, null, initialConnections, maximumConnections, this.connectionPoolOptionsSpec.getInitialConnectThreads(), this.securityOptionsSpec.getPostConnectProcessor(), false, this.connectionPoolOptionsSpec.getHealthCheck());
        this.connectionPoolOptionsSpec.applyConnectionPoolSettings(connectionPool);
        return connectionPool;
    }

    private static void validateTopLevelFields(@NotNull JSONObject o) throws LDAPException {
        boolean serverDetailsProvided = false;
        for (String s : o.getFields().keySet()) {
            if (s.equals(FIELD_SERVER_DETAILS)) {
                serverDetailsProvided = true;
                continue;
            }
            if (s.equals(FIELD_CONNECTION_OPTIONS) || s.equals(FIELD_COMMUNICATION_SECURITY) || s.equals(FIELD_AUTHENTICATION_DETAILS) || s.equals(FIELD_CONNECTION_POOL_OPTIONS)) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_UNRECOGNIZED_TOP_LEVEL_FIELD.get(s));
        }
        if (!serverDetailsProvided) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_MISSING_SERVER_DETAILS.get(FIELD_SERVER_DETAILS));
        }
    }

    static void validateAllowedFields(@NotNull JSONObject o, @NotNull String f, String ... a) throws LDAPException {
        HashSet<String> s = new HashSet<String>(Arrays.asList(a));
        for (String n : o.getFields().keySet()) {
            if (s.contains(n)) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_UNRECOGNIZED_FIELD.get(n, f));
        }
    }

    static boolean getBoolean(@NotNull JSONObject o, @NotNull String f, boolean d) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONBoolean) {
            return ((JSONBoolean)v).booleanValue();
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_BOOLEAN.get(f));
    }

    @Nullable
    static Integer getInt(@NotNull JSONObject o, @NotNull String f, @Nullable Integer d, @Nullable Integer n, @Nullable Integer x) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONNumber) {
            try {
                int i = ((JSONNumber)v).getValue().intValueExact();
                if (n != null && i < n) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_BELOW_MIN.get(f, n));
                }
                if (x != null && i > x) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_ABOVE_MAX.get(f, n));
                }
                return i;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f), e);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f));
    }

    @Nullable
    static Long getLong(@NotNull JSONObject o, @NotNull String f, @Nullable Long d, @Nullable Long n, @Nullable Long x) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONNumber) {
            try {
                long l = ((JSONNumber)v).getValue().longValueExact();
                if (n != null && l < n) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_BELOW_MIN.get(f, n));
                }
                if (x != null && l > x) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_ABOVE_MAX.get(f, n));
                }
                return l;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f), e);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f));
    }

    @Nullable
    static JSONObject getObject(@NotNull JSONObject o, @NotNull String f) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return null;
        }
        if (v instanceof JSONObject) {
            return (JSONObject)v;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_OBJECT.get(f));
    }

    @Nullable
    static String getString(@NotNull JSONObject o, @NotNull String f, @Nullable String d) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONString) {
            return ((JSONString)v).stringValue();
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_STRING.get(f));
    }

    @NotNull
    static String getStringFromFile(@NotNull String path, @NotNull String fieldName) throws LDAPException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(path));
            String line = r.readLine();
            if (line == null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_EMPTY.get(path, fieldName));
            }
            if (r.readLine() != null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_MULTIPLE_LINES.get(path, fieldName));
            }
            if (line.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_EMPTY_LINE.get(path, fieldName));
            }
            String string = line;
            return string;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_ERROR.get(path, fieldName, StaticUtils.getExceptionMessage(e)), e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
    }

    static void rejectConflictingFields(@NotNull JSONObject o, @NotNull String existingField, String ... conflictingFields) throws LDAPException {
        for (String fieldName : conflictingFields) {
            if (o.getField(fieldName) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_CONFLICTING_FIELD.get(fieldName, existingField));
        }
    }

    static void rejectUnresolvedDependency(@NotNull JSONObject o, @NotNull String requiredField, String ... dependentFields) throws LDAPException {
        for (String fieldName : dependentFields) {
            if (o.getField(fieldName) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_MISSING_DEPENDENT_FIELD.get(fieldName, requiredField));
        }
    }
}

