/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IndexMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String INDEX_MONITOR_OC = "ds-index-monitor-entry";
    @NotNull
    private static final String ATTR_INDEX_NAME = "ds-index-name";
    @NotNull
    private static final String ATTR_BACKEND_ID = "ds-index-backend-id";
    @NotNull
    private static final String ATTR_BASE_DN = "ds-index-backend-base-dn";
    @NotNull
    private static final String ATTR_INDEX_ATTR = "ds-index-attribute-type";
    @NotNull
    private static final String ATTR_INDEX_TYPE = "ds-index-type";
    @NotNull
    private static final String ATTR_INDEX_FILTER = "ds-index-filter";
    @NotNull
    private static final String ATTR_INDEX_TRUSTED = "ds-index-trusted";
    @NotNull
    private static final String ATTR_ENTRY_LIMIT = "ds-index-entry-limit";
    @NotNull
    private static final String ATTR_EXCEEDED_COUNT = "ds-index-exceeded-entry-limit-count-since-db-open";
    @NotNull
    private static final String ATTR_SEARCH_KEYS_NEAR_LIMIT = "ds-index-unique-keys-near-entry-limit-accessed-by-search-since-db-open";
    @NotNull
    private static final String ATTR_SEARCH_KEYS_OVER_LIMIT = "ds-index-unique-keys-exceeding-entry-limit-accessed-by-search-since-db-open";
    @NotNull
    private static final String ATTR_WRITE_KEYS_NEAR_LIMIT = "ds-index-unique-keys-near-entry-limit-accessed-by-write-since-db-open";
    @NotNull
    private static final String ATTR_WRITE_KEYS_OVER_LIMIT = "ds-index-unique-keys-exceeding-entry-limit-accessed-by-write-since-db-open";
    @NotNull
    private static final String ATTR_MAINTAIN_COUNT = "ds-index-maintain-count";
    @NotNull
    private static final String ATTR_FULLY_PRIMED = "ds-index-fully-primed-at-backend-open";
    @NotNull
    private static final String ATTR_PRIME_INCOMPLETE_REASON = "ds-index-prime-incomplete-reason";
    @NotNull
    private static final String ATTR_PRIME_EXCEPTION = "ds-index-prime-exception";
    @NotNull
    private static final String ATTR_PRIMED_KEYS = "ds-index-num-primed-keys-at-backend-open";
    @NotNull
    private static final String ATTR_WRITE_COUNT = "ds-index-write-count-since-db-open";
    @NotNull
    private static final String ATTR_DELETE_COUNT = "ds-index-remove-count-since-db-open";
    @NotNull
    private static final String ATTR_READ_COUNT = "ds-index-read-count-since-db-open";
    @NotNull
    private static final String ATTR_READ_FOR_SEARCH_COUNT = "ds-index-read-for-search-count-since-db-open";
    @NotNull
    private static final String ATTR_CURSOR_COUNT = "ds-index-open-cursor-count-since-db-open";
    private static final long serialVersionUID = 9182830448328951893L;
    @Nullable
    private final Boolean fullyPrimed = this.getBoolean("ds-index-fully-primed-at-backend-open");
    @Nullable
    private final Boolean indexTrusted = this.getBoolean("ds-index-trusted");
    @Nullable
    private final Boolean maintainCount = this.getBoolean("ds-index-maintain-count");
    @Nullable
    private final Long entryLimit = this.getLong("ds-index-entry-limit");
    @Nullable
    private final Long exceededCount = this.getLong("ds-index-exceeded-entry-limit-count-since-db-open");
    @Nullable
    private final Long numCursors = this.getLong("ds-index-open-cursor-count-since-db-open");
    @Nullable
    private final Long numDeletes = this.getLong("ds-index-remove-count-since-db-open");
    @Nullable
    private final Long numReads = this.getLong("ds-index-read-count-since-db-open");
    @Nullable
    private final Long numReadsForSearch = this.getLong("ds-index-read-for-search-count-since-db-open");
    @Nullable
    private final Long numWrites = this.getLong("ds-index-write-count-since-db-open");
    @Nullable
    private final Long primedKeys = this.getLong("ds-index-num-primed-keys-at-backend-open");
    @Nullable
    private final Long searchKeysNearLimit = this.getLong("ds-index-unique-keys-near-entry-limit-accessed-by-search-since-db-open");
    @Nullable
    private final Long searchKeysOverLimit = this.getLong("ds-index-unique-keys-exceeding-entry-limit-accessed-by-search-since-db-open");
    @Nullable
    private final Long writeKeysNearLimit = this.getLong("ds-index-unique-keys-near-entry-limit-accessed-by-write-since-db-open");
    @Nullable
    private final Long writeKeysOverLimit = this.getLong("ds-index-unique-keys-exceeding-entry-limit-accessed-by-write-since-db-open");
    @Nullable
    private final String attributeType = this.getString("ds-index-attribute-type");
    @Nullable
    private final String backendID = this.getString("ds-index-backend-id");
    @Nullable
    private final String baseDN = this.getString("ds-index-backend-base-dn");
    @Nullable
    private final String indexFilter = this.getString("ds-index-filter");
    @Nullable
    private final String indexName = this.getString("ds-index-name");
    @Nullable
    private final String indexType = this.getString("ds-index-type");
    @Nullable
    private final String primeException = this.getString("ds-index-prime-exception");
    @Nullable
    private final String primeIncompleteReason = this.getString("ds-index-prime-incomplete-reason");

    public IndexMonitorEntry(@NotNull Entry entry) {
        super(entry);
    }

    @Nullable
    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public String getBackendID() {
        return this.backendID;
    }

    @Nullable
    public String getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public String getAttributeType() {
        return this.attributeType;
    }

    @Nullable
    public String getAttributeIndexType() {
        return this.indexType;
    }

    @Nullable
    public String getIndexFilter() {
        return this.indexFilter;
    }

    @Nullable
    public Boolean isIndexTrusted() {
        return this.indexTrusted;
    }

    @Nullable
    public Long getIndexEntryLimit() {
        return this.entryLimit;
    }

    @Nullable
    public Long getEntryLimitExceededCountSinceComingOnline() {
        return this.exceededCount;
    }

    @Nullable
    public Long getUniqueKeysNearEntryLimitAccessedBySearchSinceComingOnline() {
        return this.searchKeysNearLimit;
    }

    @Nullable
    public Long getUniqueKeysOverEntryLimitAccessedBySearchSinceComingOnline() {
        return this.searchKeysOverLimit;
    }

    @Nullable
    public Long getUniqueKeysNearEntryLimitAccessedByWriteSinceComingOnline() {
        return this.writeKeysNearLimit;
    }

    @Nullable
    public Long getUniqueKeysOverEntryLimitAccessedByWriteSinceComingOnline() {
        return this.writeKeysOverLimit;
    }

    @Nullable
    public Boolean maintainCountForExceededKeys() {
        return this.maintainCount;
    }

    @Nullable
    public Boolean fullyPrimedWhenBroughtOnline() {
        return this.fullyPrimed;
    }

    @Nullable
    public String getPrimeIncompleteReason() {
        return this.primeIncompleteReason;
    }

    @Nullable
    public String getPrimeException() {
        return this.primeException;
    }

    @Nullable
    public Long getKeysPrimedWhenBroughtOnline() {
        return this.primedKeys;
    }

    @Nullable
    public Long getKeysWrittenSinceComingOnline() {
        return this.numWrites;
    }

    @Nullable
    public Long getKeysDeletedSinceComingOnline() {
        return this.numDeletes;
    }

    @Nullable
    public Long getKeysReadSinceComingOnline() {
        return this.numReads;
    }

    @Nullable
    public Long getFilterInitiatedReadsSinceComingOnline() {
        return this.numReadsForSearch;
    }

    @Nullable
    public Long getCursorsCreatedSinceComingOnline() {
        return this.numCursors;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_INDEX_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_INDEX_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(19));
        if (this.indexName != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_INDEX_NAME, MonitorMessages.INFO_INDEX_DISPNAME_INDEX_NAME.get(), MonitorMessages.INFO_INDEX_DESC_INDEX_NAME.get(), this.indexName);
        }
        if (this.backendID != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_BACKEND_ID, MonitorMessages.INFO_INDEX_DISPNAME_BACKEND_ID.get(), MonitorMessages.INFO_INDEX_DESC_BACKEND_ID.get(), this.backendID);
        }
        if (this.baseDN != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN, MonitorMessages.INFO_INDEX_DISPNAME_BASE_DN.get(), MonitorMessages.INFO_INDEX_DESC_BASE_DN.get(), this.baseDN);
        }
        if (this.attributeType != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_INDEX_ATTR, MonitorMessages.INFO_INDEX_DISPNAME_ATTR_TYPE.get(), MonitorMessages.INFO_INDEX_DESC_ATTR_TYPE.get(), this.attributeType);
        }
        if (this.indexType != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_INDEX_TYPE, MonitorMessages.INFO_INDEX_DISPNAME_INDEX_TYPE.get(), MonitorMessages.INFO_INDEX_DESC_INDEX_TYPE.get(), this.indexType);
        }
        if (this.indexFilter != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_INDEX_FILTER, MonitorMessages.INFO_INDEX_DISPNAME_FILTER.get(), MonitorMessages.INFO_INDEX_DESC_FILTER.get(), this.indexFilter);
        }
        if (this.indexTrusted != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_INDEX_TRUSTED, MonitorMessages.INFO_INDEX_DISPNAME_TRUSTED.get(), MonitorMessages.INFO_INDEX_DESC_TRUSTED.get(), this.indexTrusted);
        }
        if (this.entryLimit != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_ENTRY_LIMIT, MonitorMessages.INFO_INDEX_DISPNAME_ENTRY_LIMIT.get(), MonitorMessages.INFO_INDEX_DESC_ENTRY_LIMIT.get(), this.entryLimit);
        }
        if (this.exceededCount != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_EXCEEDED_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_EXCEEDED_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_EXCEEDED_COUNT.get(), this.exceededCount);
        }
        if (this.searchKeysNearLimit != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_KEYS_NEAR_LIMIT, MonitorMessages.INFO_INDEX_DISPNAME_SEARCH_KEYS_NEAR_LIMIT.get(), MonitorMessages.INFO_INDEX_DESC_SEARCH_KEYS_NEAR_LIMIT.get(), this.searchKeysNearLimit);
        }
        if (this.searchKeysOverLimit != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_KEYS_OVER_LIMIT, MonitorMessages.INFO_INDEX_DISPNAME_SEARCH_KEYS_OVER_LIMIT.get(), MonitorMessages.INFO_INDEX_DESC_SEARCH_KEYS_OVER_LIMIT.get(), this.searchKeysOverLimit);
        }
        if (this.writeKeysNearLimit != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_WRITE_KEYS_NEAR_LIMIT, MonitorMessages.INFO_INDEX_DISPNAME_WRITE_KEYS_NEAR_LIMIT.get(), MonitorMessages.INFO_INDEX_DESC_WRITE_KEYS_NEAR_LIMIT.get(), this.writeKeysNearLimit);
        }
        if (this.writeKeysOverLimit != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_WRITE_KEYS_OVER_LIMIT, MonitorMessages.INFO_INDEX_DISPNAME_WRITE_KEYS_OVER_LIMIT.get(), MonitorMessages.INFO_INDEX_DESC_WRITE_KEYS_OVER_LIMIT.get(), this.writeKeysOverLimit);
        }
        if (this.maintainCount != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_MAINTAIN_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_MAINTAIN_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_MAINTAIN_COUNT.get(), this.maintainCount);
        }
        if (this.fullyPrimed != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_FULLY_PRIMED, MonitorMessages.INFO_INDEX_DISPNAME_FULLY_PRIMED.get(), MonitorMessages.INFO_INDEX_DESC_FULLY_PRIMED.get(), this.fullyPrimed);
        }
        if (this.primeIncompleteReason != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_PRIME_INCOMPLETE_REASON, MonitorMessages.INFO_INDEX_DISPNAME_PRIME_INCOMPLETE_REASON.get(), MonitorMessages.INFO_INDEX_DESC_PRIME_INCOMPLETE_REASON.get(), this.primeIncompleteReason);
        }
        if (this.primeException != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_PRIME_EXCEPTION, MonitorMessages.INFO_INDEX_DISPNAME_PRIME_EXCEPTION.get(), MonitorMessages.INFO_INDEX_DESC_PRIME_EXCEPTION.get(), this.primeException);
        }
        if (this.primedKeys != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_PRIMED_KEYS, MonitorMessages.INFO_INDEX_DISPNAME_PRIMED_KEYS.get(), MonitorMessages.INFO_INDEX_DESC_PRIMED_KEYS.get(), this.primedKeys);
        }
        if (this.numWrites != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_WRITE_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_WRITE_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_WRITE_COUNT.get(), this.numWrites);
        }
        if (this.numDeletes != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_DELETE_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_DELETE_COUNT.get(), this.numDeletes);
        }
        if (this.numReads != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_READ_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_READ_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_READ_COUNT.get(), this.numReads);
        }
        if (this.numReadsForSearch != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_READ_FOR_SEARCH_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_FILTER_INITIATED_READ_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_FILTER_INITIATED_READ_COUNT.get(), this.numReadsForSearch);
        }
        if (this.numCursors != null) {
            IndexMonitorEntry.addMonitorAttribute(attrs, ATTR_CURSOR_COUNT, MonitorMessages.INFO_INDEX_DISPNAME_CURSOR_COUNT.get(), MonitorMessages.INFO_INDEX_DESC_CURSOR_COUNT.get(), this.numCursors);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

