/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.AttributeBasedLogFieldSyntaxHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FilterLogFieldSyntax
extends LogFieldSyntax<Filter> {
    @NotNull
    public static final String SYNTAX_NAME = "filter";
    @NotNull
    private static final String REDACTED_FILTER_STRING = "(redacted={REDACTED})";
    private final boolean allAttributesAreSensitive;
    @NotNull
    private final Set<String> excludedSensitiveAttributes;
    @NotNull
    private final Set<String> includedSensitiveAttributes;

    public FilterLogFieldSyntax(int maxStringLengthCharacters, @Nullable Schema schema, @Nullable Collection<String> includedSensitiveAttributes, @Nullable Collection<String> excludedSensitiveAttributes) {
        super(maxStringLengthCharacters);
        this.includedSensitiveAttributes = AttributeBasedLogFieldSyntaxHelper.getAttributeSet(schema, includedSensitiveAttributes);
        this.excludedSensitiveAttributes = AttributeBasedLogFieldSyntaxHelper.getAttributeSet(schema, excludedSensitiveAttributes);
        this.allAttributesAreSensitive = this.includedSensitiveAttributes.isEmpty() && this.excludedSensitiveAttributes.isEmpty();
    }

    @NotNull
    public Set<String> getIncludedSensitiveAttributes() {
        return this.includedSensitiveAttributes;
    }

    @NotNull
    public Set<String> getExcludedSensitiveAttributes() {
        return this.excludedSensitiveAttributes;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull Filter value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.sanitizeFilter(value).toString());
    }

    @NotNull
    private Filter sanitizeFilter(@NotNull Filter filter) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] originalANDComponents = filter.getComponents();
                Filter[] sanitizedANDComponents = new Filter[originalANDComponents.length];
                for (int i = 0; i < originalANDComponents.length; ++i) {
                    sanitizedANDComponents[i] = this.sanitizeFilter(originalANDComponents[i]);
                }
                return Filter.createANDFilter(sanitizedANDComponents);
            }
            case -95: {
                Filter[] originalORComponents = filter.getComponents();
                Filter[] sanitizedORComponents = new Filter[originalORComponents.length];
                for (int i = 0; i < originalORComponents.length; ++i) {
                    sanitizedORComponents[i] = this.sanitizeFilter(originalORComponents[i]);
                }
                return Filter.createORFilter(sanitizedORComponents);
            }
            case -94: {
                return Filter.createNOTFilter(this.sanitizeFilter(filter.getNOTComponent()));
            }
            case -93: {
                return Filter.createEqualityFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -91: {
                return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -90: {
                return Filter.createLessOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -88: {
                return Filter.createApproximateMatchFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -92: {
                String originalSubInitial = filter.getSubInitialString();
                String sanitizedSubInitial = originalSubInitial == null ? null : this.sanitize(originalSubInitial);
                String originalSubFinal = filter.getSubFinalString();
                String sanitizedSubFinal = originalSubFinal == null ? null : this.sanitize(originalSubFinal);
                String[] originalSubAny = filter.getSubAnyStrings();
                String[] sanitizedSubAny = new String[originalSubAny.length];
                for (int i = 0; i < originalSubAny.length; ++i) {
                    sanitizedSubAny[i] = this.sanitize(originalSubAny[i]);
                }
                return Filter.createSubstringFilter(filter.getAttributeName(), sanitizedSubInitial, sanitizedSubAny, sanitizedSubFinal);
            }
            case -87: {
                return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), this.sanitize(filter.getAssertionValue()));
            }
        }
        return filter;
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.valueToSanitizedString(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.valueToSanitizedString(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Filter value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.valueToSanitizedString(value));
    }

    @Override
    @NotNull
    public Filter parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return Filter.create(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIsCompletelyRedacted(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIsCompletelyTokenized(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_FILTER_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_FILTER_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_FILTER_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(REDACTED_FILTER_STRING);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, REDACTED_FILTER_STRING);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString(REDACTED_FILTER_STRING);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return true;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void redactComponents(@NotNull Filter value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.redactFilter(value).toString());
    }

    @NotNull
    private Filter redactFilter(@NotNull Filter filter) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] originalANDComponents = filter.getComponents();
                Filter[] redactedANDComponents = new Filter[originalANDComponents.length];
                for (int i = 0; i < originalANDComponents.length; ++i) {
                    redactedANDComponents[i] = this.redactFilter(originalANDComponents[i]);
                }
                return Filter.createANDFilter(redactedANDComponents);
            }
            case -95: {
                Filter[] originalORComponents = filter.getComponents();
                Filter[] redactedORComponents = new Filter[originalORComponents.length];
                for (int i = 0; i < originalORComponents.length; ++i) {
                    redactedORComponents[i] = this.redactFilter(originalORComponents[i]);
                }
                return Filter.createORFilter(redactedORComponents);
            }
            case -94: {
                return Filter.createNOTFilter(this.redactFilter(filter.getNOTComponent()));
            }
            case -93: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createEqualityFilter(filter.getAttributeName(), "{REDACTED}");
                }
                return Filter.createEqualityFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -91: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), "{REDACTED}");
                }
                return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -90: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createLessOrEqualFilter(filter.getAttributeName(), "{REDACTED}");
                }
                return Filter.createLessOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -88: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createApproximateMatchFilter(filter.getAttributeName(), "{REDACTED}");
                }
                return Filter.createApproximateMatchFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -92: {
                String redactedSubFinal;
                String redactedSubInitial;
                String originalSubInitial = filter.getSubInitialString();
                String originalSubFinal = filter.getSubFinalString();
                String[] originalSubAny = filter.getSubAnyStrings();
                Object[] redactedSubAny = new String[originalSubAny.length];
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    redactedSubInitial = originalSubInitial == null ? null : "{REDACTED}";
                    redactedSubFinal = originalSubFinal == null ? null : "{REDACTED}";
                    Arrays.fill(redactedSubAny, "{REDACTED}");
                } else {
                    redactedSubInitial = originalSubInitial == null ? null : this.sanitize(originalSubInitial);
                    redactedSubFinal = originalSubFinal == null ? null : this.sanitize(originalSubFinal);
                    for (int i = 0; i < originalSubAny.length; ++i) {
                        redactedSubAny[i] = this.sanitize(originalSubAny[i]);
                    }
                }
                return Filter.createSubstringFilter(filter.getAttributeName(), redactedSubInitial, (String[])redactedSubAny, redactedSubFinal);
            }
            case -87: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), "{REDACTED}");
                }
                return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), this.sanitize(filter.getAssertionValue()));
            }
            case -121: {
                return filter;
            }
        }
        return Filter.createEqualityFilter("redacted", "{REDACTED}");
    }

    private boolean shouldRedactOrTokenize(@Nullable String attributeName) {
        if (this.allAttributesAreSensitive) {
            return true;
        }
        if (attributeName == null) {
            return !this.excludedSensitiveAttributes.isEmpty();
        }
        String lowerName = StaticUtils.toLowerCase(Attribute.getBaseName(attributeName));
        if (this.includedSensitiveAttributes.contains(lowerName)) {
            return true;
        }
        if (this.excludedSensitiveAttributes.isEmpty()) {
            return false;
        }
        return !this.excludedSensitiveAttributes.contains(lowerName);
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.redactComponents(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.redactComponents(fieldValue));
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Filter value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.redactComponents(value));
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        return super.valueStringIsCompletelyTokenized(valueString) || valueString.startsWith("(tokenized={TOKENIZED:") && valueString.endsWith("})");
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeEntireValue(@NotNull Filter value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append("(tokenized=");
        this.tokenize(value.toNormalizedString(), pepper, buffer);
        buffer.append(')');
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Filter value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return true;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeComponents(@NotNull Filter value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.tokenizeFilter(value, pepper).toString());
    }

    @NotNull
    private Filter tokenizeFilter(@NotNull Filter filter, @NotNull byte[] pepper) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] originalANDComponents = filter.getComponents();
                Filter[] tokenizedANDComponents = new Filter[originalANDComponents.length];
                for (int i = 0; i < originalANDComponents.length; ++i) {
                    tokenizedANDComponents[i] = this.tokenizeFilter(originalANDComponents[i], pepper);
                }
                return Filter.createANDFilter(tokenizedANDComponents);
            }
            case -95: {
                Filter[] originalORComponents = filter.getComponents();
                Filter[] tokenizedORComponents = new Filter[originalORComponents.length];
                for (int i = 0; i < originalORComponents.length; ++i) {
                    tokenizedORComponents[i] = this.tokenizeFilter(originalORComponents[i], pepper);
                }
                return Filter.createORFilter(tokenizedORComponents);
            }
            case -94: {
                return Filter.createNOTFilter(this.tokenizeFilter(filter.getNOTComponent(), pepper));
            }
            case -93: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createEqualityFilter(filter.getAttributeName(), this.tokenize(filter.getAssertionValue(), pepper));
                }
                return Filter.createEqualityFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -91: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), this.tokenize(filter.getAssertionValue(), pepper));
                }
                return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -90: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createLessOrEqualFilter(filter.getAttributeName(), this.tokenize(filter.getAssertionValue(), pepper));
                }
                return Filter.createLessOrEqualFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -88: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createApproximateMatchFilter(filter.getAttributeName(), this.tokenize(filter.getAssertionValue(), pepper));
                }
                return Filter.createApproximateMatchFilter(filter.getAttributeName(), this.sanitize(filter.getAssertionValue()));
            }
            case -92: {
                String tokenizedSubFinal;
                String tokenizedSubInitial;
                String originalSubInitial = filter.getSubInitialString();
                String originalSubFinal = filter.getSubFinalString();
                String[] originalSubAny = filter.getSubAnyStrings();
                String[] tokenizedSubAny = new String[originalSubAny.length];
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    tokenizedSubInitial = originalSubInitial == null ? null : this.tokenize(originalSubInitial, pepper);
                    tokenizedSubFinal = originalSubFinal == null ? null : this.tokenize(originalSubFinal, pepper);
                    for (int i = 0; i < originalSubAny.length; ++i) {
                        tokenizedSubAny[i] = this.tokenize(originalSubAny[i], pepper);
                    }
                } else {
                    tokenizedSubInitial = originalSubInitial == null ? null : this.sanitize(originalSubInitial);
                    tokenizedSubFinal = originalSubFinal == null ? null : this.sanitize(originalSubFinal);
                    for (int i = 0; i < originalSubAny.length; ++i) {
                        tokenizedSubAny[i] = this.sanitize(originalSubAny[i]);
                    }
                }
                return Filter.createSubstringFilter(filter.getAttributeName(), tokenizedSubInitial, tokenizedSubAny, tokenizedSubFinal);
            }
            case -87: {
                if (this.shouldRedactOrTokenize(filter.getAttributeName())) {
                    return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), this.tokenize(filter.getAssertionValue(), pepper));
                }
                return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), this.sanitize(filter.getAssertionValue()));
            }
        }
        return filter;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeComponents(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Filter fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeComponents(fieldValue, pepper));
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Filter value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeComponents(value, pepper));
    }
}

