/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateOperation;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyStateExtendedResult
extends ExtendedResult {
    private static final long serialVersionUID = 7140468768443263344L;
    @NotNull
    private final Map<Integer, PasswordPolicyStateOperation> operations;
    @Nullable
    private final String userDN;

    public PasswordPolicyStateExtendedResult(@NotNull ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1Element[] elements;
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.userDN = null;
            this.operations = Collections.emptyMap();
            return;
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_RESPONSE_VALUE_NOT_SEQUENCE.get(e), e);
        }
        if (elements.length < 1 || elements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_RESPONSE_INVALID_ELEMENT_COUNT.get(elements.length));
        }
        this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        LinkedHashMap<Integer, PasswordPolicyStateOperation> ops = new LinkedHashMap<Integer, PasswordPolicyStateOperation>(StaticUtils.computeMapCapacity(20));
        if (elements.length == 2) {
            try {
                ASN1Element[] opElements;
                for (ASN1Element e : opElements = ASN1Sequence.decodeAsSequence(elements[1]).elements()) {
                    PasswordPolicyStateOperation op = PasswordPolicyStateOperation.decode(e);
                    ops.put(op.getOperationType(), op);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_RESPONSE_CANNOT_DECODE_OPS.get(e), e);
            }
        }
        this.operations = Collections.unmodifiableMap(ops);
    }

    public PasswordPolicyStateExtendedResult(int messageID, @NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable String[] referralURLs, @Nullable String userDN, @Nullable PasswordPolicyStateOperation[] operations, @Nullable Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, PasswordPolicyStateExtendedResult.encodeValue(userDN, operations), responseControls);
        this.userDN = userDN;
        if (operations == null || operations.length == 0) {
            this.operations = Collections.emptyMap();
        } else {
            LinkedHashMap<Integer, PasswordPolicyStateOperation> ops = new LinkedHashMap<Integer, PasswordPolicyStateOperation>(StaticUtils.computeMapCapacity(operations.length));
            for (PasswordPolicyStateOperation o : operations) {
                ops.put(o.getOperationType(), o);
            }
            this.operations = Collections.unmodifiableMap(ops);
        }
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable String userDN, @Nullable PasswordPolicyStateOperation[] operations) {
        if (userDN == null && (operations == null || operations.length == 0)) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(userDN));
        if (operations != null && operations.length > 0) {
            ASN1Element[] opElements = new ASN1Element[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                opElements[i] = operations[i].encode();
            }
            elements.add(new ASN1Sequence(opElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getUserDN() {
        return this.userDN;
    }

    @NotNull
    public Iterable<PasswordPolicyStateOperation> getOperations() {
        return this.operations.values();
    }

    @Nullable
    public PasswordPolicyStateOperation getOperation(int opType) {
        return this.operations.get(opType);
    }

    @Nullable
    public String getStringValue(int opType) {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            return null;
        }
        return op.getStringValue();
    }

    @Nullable
    public String[] getStringValues(int opType) {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            return null;
        }
        return op.getStringValues();
    }

    public boolean getBooleanValue(int opType) throws NoSuchElementException, IllegalStateException {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            throw new NoSuchElementException(ExtOpMessages.ERR_PWP_STATE_RESPONSE_NO_SUCH_OPERATION.get());
        }
        return op.getBooleanValue();
    }

    public int getIntValue(int opType) throws NoSuchElementException, IllegalStateException {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            throw new NoSuchElementException(ExtOpMessages.ERR_PWP_STATE_RESPONSE_NO_SUCH_OPERATION.get());
        }
        return op.getIntValue();
    }

    @Nullable
    public Date getGeneralizedTimeValue(int opType) throws ParseException {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            return null;
        }
        return op.getGeneralizedTimeValue();
    }

    @Nullable
    public Date[] getGeneralizedTimeValues(int opType) throws ParseException {
        PasswordPolicyStateOperation op = this.operations.get(opType);
        if (op == null) {
            return null;
        }
        return op.getGeneralizedTimeValues();
    }

    @Override
    @NotNull
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_PW_POLICY_STATE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("PasswordPolicyStateExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        buffer.append(", userDN='");
        buffer.append(this.userDN);
        buffer.append("', operations={");
        Iterator<PasswordPolicyStateOperation> iterator = this.operations.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        String diagnosticMessage = this.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

