/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CollectSupportDataArchiveFragmentIntermediateResponse
extends IntermediateResponse {
    @NotNull
    public static final String COLLECT_SUPPORT_DATA_ARCHIVE_FRAGMENT_INTERMEDIATE_RESPONSE_OID = "1.3.6.1.4.1.30221.2.6.66";
    private static final byte TYPE_ARCHIVE_FILE_NAME = -128;
    private static final byte TYPE_TOTAL_ARCHIVE_SIZE_BYTES = -127;
    private static final byte TYPE_MORE_DATA_TO_RETURN = -126;
    private static final byte TYPE_FRAGMENT_DATA = -125;
    private static final long serialVersionUID = 6989352662115346422L;
    private final boolean moreDataToReturn;
    @NotNull
    private final byte[] fragmentData;
    private final long totalArchiveSizeBytes;
    @NotNull
    private final String archiveFileName;

    public CollectSupportDataArchiveFragmentIntermediateResponse(@NotNull String archiveFileName, long totalArchiveSizeBytes, boolean moreDataToReturn, @NotNull byte[] fragmentData, Control ... controls) {
        super(COLLECT_SUPPORT_DATA_ARCHIVE_FRAGMENT_INTERMEDIATE_RESPONSE_OID, CollectSupportDataArchiveFragmentIntermediateResponse.encodeValue(archiveFileName, totalArchiveSizeBytes, moreDataToReturn, fragmentData), controls);
        this.archiveFileName = archiveFileName;
        this.totalArchiveSizeBytes = totalArchiveSizeBytes;
        this.moreDataToReturn = moreDataToReturn;
        this.fragmentData = fragmentData;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String archiveFileName, long totalArchiveSizeBytes, boolean moreDataToReturn, @NotNull byte[] fragmentData) {
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(-128, archiveFileName), new ASN1Long(-127, totalArchiveSizeBytes), new ASN1Boolean(-126, moreDataToReturn), new ASN1OctetString(-125, fragmentData));
        return new ASN1OctetString(valueSequence.encode());
    }

    public CollectSupportDataArchiveFragmentIntermediateResponse(@NotNull IntermediateResponse intermediateResponse) throws LDAPException {
        super(intermediateResponse);
        ASN1OctetString value = intermediateResponse.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_FRAGMENT_IR_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Element[] elements = valueSequence.elements();
            this.archiveFileName = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.totalArchiveSizeBytes = ASN1Long.decodeAsLong(elements[1]).longValue();
            this.moreDataToReturn = ASN1Boolean.decodeAsBoolean(elements[2]).booleanValue();
            this.fragmentData = ASN1OctetString.decodeAsOctetString(elements[3]).getValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CSD_FRAGMENT_IR_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public long getTotalArchiveSizeBytes() {
        return this.totalArchiveSizeBytes;
    }

    public boolean moreDataToReturn() {
        return this.moreDataToReturn;
    }

    @NotNull
    public byte[] getFragmentData() {
        return this.fragmentData;
    }

    @Override
    @NotNull
    public String getIntermediateResponseName() {
        return ExtOpMessages.INFO_COLLECT_SUPPORT_DATA_FRAGMENT_IR_NAME.get();
    }

    @Override
    @NotNull
    public String valueToString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("archiveFileName='");
        buffer.append(this.archiveFileName);
        buffer.append("' totalArchiveSizeBytes=");
        buffer.append(this.totalArchiveSizeBytes);
        buffer.append(" moreDataToReturn=");
        buffer.append(this.moreDataToReturn);
        buffer.append(" fragmentSizeBytes=");
        buffer.append(this.fragmentData.length);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("CollectSupportDataArchiveFragmentIntermediateResponse(oid='");
        buffer.append(this.getOID());
        buffer.append("', archiveFileName='");
        buffer.append(this.archiveFileName);
        buffer.append("', totalArchiveSizeBytes=");
        buffer.append(this.totalArchiveSizeBytes);
        buffer.append(", moreDataToReturn=");
        buffer.append(this.moreDataToReturn);
        buffer.append(", fragmentSizeBytes=");
        buffer.append(this.fragmentData.length);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

