/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationServerResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AssuredReplicationServerResult
implements Serializable {
    private static final byte TYPE_RESULT_CODE = -128;
    private static final byte TYPE_SERVER_ID = -127;
    private static final byte TYPE_REPLICA_ID = -126;
    private static final long serialVersionUID = 3015162215769386343L;
    @NotNull
    private final AssuredReplicationServerResultCode resultCode;
    @Nullable
    private final Short replicaID;
    @Nullable
    private final Short replicationServerID;

    public AssuredReplicationServerResult(@NotNull AssuredReplicationServerResultCode resultCode, @Nullable Short replicationServerID, @Nullable Short replicaID) {
        this.resultCode = resultCode;
        this.replicationServerID = replicationServerID;
        this.replicaID = replicaID;
    }

    @NotNull
    public AssuredReplicationServerResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public Short getReplicationServerID() {
        return this.replicationServerID;
    }

    @Nullable
    public Short getReplicaID() {
        return this.replicaID;
    }

    @NotNull
    ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1Enumerated(-128, this.resultCode.intValue()));
        if (this.replicationServerID != null) {
            elements.add(new ASN1Integer(-127, this.replicationServerID.shortValue()));
        }
        if (this.replicaID != null) {
            elements.add(new ASN1Integer(-126, this.replicaID.shortValue()));
        }
        return new ASN1Sequence(elements);
    }

    @NotNull
    static AssuredReplicationServerResult decode(@NotNull ASN1Element element) throws LDAPException {
        AssuredReplicationServerResultCode resultCode = null;
        Short serverID = null;
        Short replicaID = null;
        try {
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
                switch (e.getType()) {
                    case -128: {
                        int rcValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        resultCode = AssuredReplicationServerResultCode.valueOf(rcValue);
                        if (resultCode != null) continue block8;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_SERVER_RESULT_INVALID_RESULT_CODE.get(rcValue));
                    }
                    case -127: {
                        serverID = (short)ASN1Integer.decodeAsInteger(e).intValue();
                        continue block8;
                    }
                    case -126: {
                        replicaID = (short)ASN1Integer.decodeAsInteger(e).intValue();
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_SERVER_RESULT_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_SERVER_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (resultCode == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ASSURED_REPLICATION_SERVER_RESULT_NO_RESULT_CODE.get());
        }
        return new AssuredReplicationServerResult(resultCode, serverID, replicaID);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AssuredReplicationServerResult(resultCode=");
        buffer.append(this.resultCode.name());
        if (this.replicationServerID != null) {
            buffer.append(", replicationServerID=");
            buffer.append(this.replicationServerID);
        }
        if (this.replicaID != null) {
            buffer.append(", replicaID=");
            buffer.append(this.replicaID);
        }
        buffer.append(')');
    }
}

