/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.AlarmSeverity;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AlarmEntry
extends ReadOnlyEntry {
    private static final long serialVersionUID = -2481622467368820030L;
    @Nullable
    private final AlarmSeverity currentSeverity;
    @Nullable
    private final AlarmSeverity previousSeverity;
    @Nullable
    private final Date lastCriticalTime;
    @Nullable
    private final Date lastIndeterminateTime;
    @Nullable
    private final Date lastMajorTime;
    @Nullable
    private final Date lastMinorTime;
    @Nullable
    private final Date lastNormalTime;
    @Nullable
    private final Date lastWarningTime;
    @Nullable
    private final Date startTime;
    @Nullable
    private final Integer eventType;
    @Nullable
    private final Integer probableCause;
    @Nullable
    private final Long totalDurationCriticalMillis;
    @Nullable
    private final Long totalDurationIndeterminateMillis;
    @Nullable
    private final Long totalDurationMajorMillis;
    @Nullable
    private final Long totalDurationMinorMillis;
    @Nullable
    private final Long totalDurationNormalMillis;
    @Nullable
    private final Long totalDurationWarningMillis;
    @Nullable
    private final String additionalText;
    @Nullable
    private final String condition;
    @Nullable
    private final String details;
    @Nullable
    private final String id;
    @Nullable
    private final String specificResource;
    @Nullable
    private final String specificResourceType;

    public AlarmEntry(@NotNull Entry entry) {
        super(entry);
        this.id = entry.getAttributeValue("ds-alarm-id");
        this.condition = entry.getAttributeValue("ds-alarm-condition");
        this.startTime = entry.getAttributeValueAsDate("ds-alarm-start-time");
        this.specificResource = entry.getAttributeValue("ds-alarm-specific-resource");
        this.specificResourceType = entry.getAttributeValue("ds-alarm-specific-resource-type");
        this.details = entry.getAttributeValue("ds-alarm-details");
        this.additionalText = entry.getAttributeValue("ds-alarm-additional-text");
        this.lastNormalTime = entry.getAttributeValueAsDate("ds-alarm-normal-last-time");
        this.lastWarningTime = entry.getAttributeValueAsDate("ds-alarm-warning-last-time");
        this.lastMinorTime = entry.getAttributeValueAsDate("ds-alarm-minor-last-time");
        this.lastMajorTime = entry.getAttributeValueAsDate("ds-alarm-major-last-time");
        this.lastCriticalTime = entry.getAttributeValueAsDate("ds-alarm-critical-last-time");
        this.lastIndeterminateTime = entry.getAttributeValueAsDate("ds-alarm-indeterminate-last-time");
        this.totalDurationNormalMillis = entry.getAttributeValueAsLong("ds-alarm-normal-total-duration-millis");
        this.totalDurationWarningMillis = entry.getAttributeValueAsLong("ds-alarm-warning-total-duration-millis");
        this.totalDurationMinorMillis = entry.getAttributeValueAsLong("ds-alarm-minor-total-duration-millis");
        this.totalDurationMajorMillis = entry.getAttributeValueAsLong("ds-alarm-major-total-duration-millis");
        this.totalDurationCriticalMillis = entry.getAttributeValueAsLong("ds-alarm-critical-total-duration-millis");
        this.totalDurationIndeterminateMillis = entry.getAttributeValueAsLong("ds-alarm-indeterminate-total-duration-millis");
        this.eventType = entry.getAttributeValueAsInteger("ds-alarm-event-type");
        this.probableCause = entry.getAttributeValueAsInteger("ds-alarm-probable-cause");
        String currentSeverityStr = entry.getAttributeValue("ds-alarm-severity");
        this.currentSeverity = currentSeverityStr == null ? null : AlarmSeverity.forName(currentSeverityStr);
        String previousSeverityStr = entry.getAttributeValue("ds-alarm-previous-severity");
        this.previousSeverity = previousSeverityStr == null ? null : AlarmSeverity.forName(previousSeverityStr);
    }

    @Nullable
    public String getAlarmID() {
        return this.id;
    }

    @Nullable
    public String getAlarmCondition() {
        return this.condition;
    }

    @Nullable
    public AlarmSeverity getCurrentAlarmSeverity() {
        return this.currentSeverity;
    }

    @Nullable
    public AlarmSeverity getPreviousAlarmSeverity() {
        return this.previousSeverity;
    }

    @Nullable
    public Date getAlarmStartTime() {
        return this.startTime;
    }

    @Nullable
    public String getAlarmSpecificResource() {
        return this.specificResource;
    }

    @Nullable
    public String getAlarmSpecificResourceType() {
        return this.specificResourceType;
    }

    @Nullable
    public String getAlarmDetails() {
        return this.details;
    }

    @Nullable
    public String getAlarmAdditionalText() {
        return this.additionalText;
    }

    @Nullable
    public Date getAlarmLastNormalTime() {
        return this.lastNormalTime;
    }

    @Nullable
    public Date getAlarmLastWarningTime() {
        return this.lastWarningTime;
    }

    @Nullable
    public Date getAlarmLastMinorTime() {
        return this.lastMinorTime;
    }

    @Nullable
    public Date getAlarmLastMajorTime() {
        return this.lastMajorTime;
    }

    @Nullable
    public Date getAlarmLastCriticalTime() {
        return this.lastCriticalTime;
    }

    @Nullable
    public Date getAlarmLastIndeterminateTime() {
        return this.lastIndeterminateTime;
    }

    @Nullable
    public Long getAlarmTotalDurationNormalMillis() {
        return this.totalDurationNormalMillis;
    }

    @Nullable
    public Long getAlarmTotalDurationWarningMillis() {
        return this.totalDurationWarningMillis;
    }

    @Nullable
    public Long getAlarmTotalDurationMinorMillis() {
        return this.totalDurationMinorMillis;
    }

    @Nullable
    public Long getAlarmTotalDurationMajorMillis() {
        return this.totalDurationMajorMillis;
    }

    @Nullable
    public Long getAlarmTotalDurationCriticalMillis() {
        return this.totalDurationCriticalMillis;
    }

    @Nullable
    public Long getAlarmTotalDurationIndeterminateMillis() {
        return this.totalDurationIndeterminateMillis;
    }

    @Nullable
    public Integer getAlarmEventType() {
        return this.eventType;
    }

    @Nullable
    public Integer getAlarmProbableCause() {
        return this.probableCause;
    }
}

