/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ObjectClassType {
    ABSTRACT("ABSTRACT"),
    STRUCTURAL("STRUCTURAL"),
    AUXILIARY("AUXILIARY");

    @NotNull
    private final String name;

    private ObjectClassType(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static ObjectClassType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "abstract": {
                return ABSTRACT;
            }
            case "structural": {
                return STRUCTURAL;
            }
            case "auxiliary": {
                return AUXILIARY;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

