/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VirtualListViewRequestControl
extends Control {
    @NotNull
    public static final String VIRTUAL_LIST_VIEW_REQUEST_OID = "2.16.840.1.113730.3.4.9";
    private static final byte TARGET_TYPE_OFFSET = -96;
    private static final byte TARGET_TYPE_GREATER_OR_EQUAL = -127;
    @NotNull
    private static final String JSON_FIELD_AFTER_COUNT = "after-count";
    @NotNull
    private static final String JSON_FIELD_ASSERTION_VALUE = "assertion-value";
    @NotNull
    private static final String JSON_FIELD_BEFORE_COUNT = "before-count";
    @NotNull
    private static final String JSON_FIELD_CONTENT_COUNT = "content-count";
    @NotNull
    private static final String JSON_FIELD_CONTEXT_ID = "context-id";
    @NotNull
    private static final String JSON_FIELD_TARGET_OFFSET = "target-offset";
    private static final long serialVersionUID = 4348423177859960815L;
    @Nullable
    private final ASN1OctetString assertionValue;
    @Nullable
    private final ASN1OctetString contextID;
    private final int afterCount;
    private final int beforeCount;
    private final int contentCount;
    private final int targetOffset;

    public VirtualListViewRequestControl(int targetOffset, int beforeCount, int afterCount, int contentCount, @Nullable ASN1OctetString contextID) {
        this(targetOffset, beforeCount, afterCount, contentCount, contextID, true);
    }

    public VirtualListViewRequestControl(@NotNull String assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(@NotNull byte[] assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(@NotNull ASN1OctetString assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID) {
        this(assertionValue, beforeCount, afterCount, contextID, true);
    }

    public VirtualListViewRequestControl(int targetOffset, int beforeCount, int afterCount, int contentCount, @Nullable ASN1OctetString contextID, boolean isCritical) {
        super(VIRTUAL_LIST_VIEW_REQUEST_OID, isCritical, VirtualListViewRequestControl.encodeValue(targetOffset, beforeCount, afterCount, contentCount, contextID));
        this.targetOffset = targetOffset;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contentCount = contentCount;
        this.contextID = contextID;
        this.assertionValue = null;
    }

    public VirtualListViewRequestControl(@NotNull String assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID, boolean isCritical) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, isCritical);
    }

    public VirtualListViewRequestControl(@NotNull byte[] assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID, boolean isCritical) {
        this(new ASN1OctetString(assertionValue), beforeCount, afterCount, contextID, isCritical);
    }

    public VirtualListViewRequestControl(@NotNull ASN1OctetString assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID, boolean isCritical) {
        super(VIRTUAL_LIST_VIEW_REQUEST_OID, isCritical, VirtualListViewRequestControl.encodeValue(assertionValue, beforeCount, afterCount, contextID));
        this.assertionValue = assertionValue;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contextID = contextID;
        this.targetOffset = -1;
        this.contentCount = -1;
    }

    public VirtualListViewRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.beforeCount = ASN1Integer.decodeAsInteger(elements[0]).intValue();
            this.afterCount = ASN1Integer.decodeAsInteger(elements[1]).intValue();
            switch (elements[2].getType()) {
                case -96: {
                    this.assertionValue = null;
                    ASN1Element[] offsetElements = ASN1Sequence.decodeAsSequence(elements[2]).elements();
                    this.targetOffset = ASN1Integer.decodeAsInteger(offsetElements[0]).intValue();
                    this.contentCount = ASN1Integer.decodeAsInteger(offsetElements[1]).intValue();
                    break;
                }
                case -127: {
                    this.assertionValue = ASN1OctetString.decodeAsOctetString(elements[2]);
                    this.targetOffset = -1;
                    this.contentCount = -1;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[2].getType())));
                }
            }
            this.contextID = elements.length == 4 ? ASN1OctetString.decodeAsOctetString(elements[3]) : null;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(int targetOffset, int beforeCount, int afterCount, int contentCount, @Nullable ASN1OctetString contextID) {
        ASN1Element[] targetElements = new ASN1Element[]{new ASN1Integer(targetOffset), new ASN1Integer(contentCount)};
        ASN1Element[] vlvElements = contextID == null ? new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1Sequence(-96, targetElements)} : new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1Sequence(-96, targetElements), contextID};
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ASN1OctetString assertionValue, int beforeCount, int afterCount, @Nullable ASN1OctetString contextID) {
        Validator.ensureNotNull(assertionValue);
        ASN1Element[] vlvElements = contextID == null ? new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1OctetString(-127, assertionValue.getValue())} : new ASN1Element[]{new ASN1Integer(beforeCount), new ASN1Integer(afterCount), new ASN1OctetString(-127, assertionValue.getValue()), contextID};
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    @Nullable
    public String getAssertionValueString() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.stringValue();
    }

    @Nullable
    public byte[] getAssertionValueBytes() {
        if (this.assertionValue == null) {
            return null;
        }
        return this.assertionValue.getValue();
    }

    @Nullable
    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    @Nullable
    public ASN1OctetString getContextID() {
        return this.contextID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_VLV_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.assertionValue == null) {
            valueFields.put(JSON_FIELD_TARGET_OFFSET, new JSONNumber(this.targetOffset));
        } else {
            valueFields.put(JSON_FIELD_ASSERTION_VALUE, new JSONString(this.assertionValue.stringValue()));
        }
        valueFields.put(JSON_FIELD_BEFORE_COUNT, new JSONNumber(this.beforeCount));
        valueFields.put(JSON_FIELD_AFTER_COUNT, new JSONNumber(this.afterCount));
        if (this.assertionValue == null) {
            valueFields.put(JSON_FIELD_CONTENT_COUNT, new JSONNumber(this.contentCount));
        }
        if (this.contextID != null) {
            valueFields.put(JSON_FIELD_CONTEXT_ID, new JSONString(Base64.encode(this.contextID.getValue())));
        }
        return new JSONObject(new JSONField("oid", VIRTUAL_LIST_VIEW_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_VLV_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static VirtualListViewRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ASN1OctetString contextID;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new VirtualListViewRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer targetOffset = valueObject.getFieldAsInteger(JSON_FIELD_TARGET_OFFSET);
        String assertionValue = valueObject.getFieldAsString(JSON_FIELD_ASSERTION_VALUE);
        if (targetOffset == null && assertionValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_NEITHER_OFFSET_NOR_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_TARGET_OFFSET, JSON_FIELD_ASSERTION_VALUE));
        }
        if (targetOffset != null && assertionValue != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_BOTH_OFFSET_AND_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_TARGET_OFFSET, JSON_FIELD_ASSERTION_VALUE));
        }
        Integer beforeCount = valueObject.getFieldAsInteger(JSON_FIELD_BEFORE_COUNT);
        if (beforeCount == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_BEFORE_COUNT));
        }
        Integer afterCount = valueObject.getFieldAsInteger(JSON_FIELD_AFTER_COUNT);
        if (afterCount == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_AFTER_COUNT));
        }
        Integer contentCount = valueObject.getFieldAsInteger(JSON_FIELD_CONTENT_COUNT);
        if (contentCount == null) {
            contentCount = 0;
        } else if (assertionValue != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_CONTENT_COUNT_WITH_ASSERTION_VALUE.get(controlObject.toSingleLineString(), JSON_FIELD_CONTENT_COUNT, JSON_FIELD_ASSERTION_VALUE));
        }
        String contextIDBase64 = valueObject.getFieldAsString(JSON_FIELD_CONTEXT_ID);
        if (contextIDBase64 == null) {
            contextID = null;
        } else {
            try {
                contextID = new ASN1OctetString(Base64.decode(contextIDBase64));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_CONTEXT_ID_NOT_BASE64.get(controlObject.toSingleLineString(), JSON_FIELD_CONTEXT_ID), e);
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_TARGET_OFFSET, JSON_FIELD_ASSERTION_VALUE, JSON_FIELD_BEFORE_COUNT, JSON_FIELD_AFTER_COUNT, JSON_FIELD_CONTENT_COUNT, JSON_FIELD_CONTEXT_ID)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        if (assertionValue == null) {
            return new VirtualListViewRequestControl(targetOffset, beforeCount, afterCount, contentCount, contextID, jsonControl.getCriticality());
        }
        return new VirtualListViewRequestControl(assertionValue, (int)beforeCount, (int)afterCount, contextID, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("VirtualListViewRequestControl(beforeCount=");
        buffer.append(this.beforeCount);
        buffer.append(", afterCount=");
        buffer.append(this.afterCount);
        if (this.assertionValue == null) {
            buffer.append(", targetOffset=");
            buffer.append(this.targetOffset);
            buffer.append(", contentCount=");
            buffer.append(this.contentCount);
        } else {
            buffer.append(", assertionValue='");
            buffer.append(this.assertionValue.stringValue());
            buffer.append('\'');
        }
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

