/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

class AddressResolverGroupMetrics<T extends SocketAddress>
extends AddressResolverGroup<T> {
    private static final Logger log = Loggers.getLogger(AddressResolverGroupMetrics.class);
    static final ConcurrentMap<Integer, AddressResolverGroupMetrics<?>> cache = new ConcurrentHashMap();
    final AddressResolverGroup<T> resolverGroup;
    final ChannelMetricsRecorder recorder;

    static AddressResolverGroupMetrics<?> getOrCreate(AddressResolverGroup<?> resolverGroup, ChannelMetricsRecorder recorder) {
        return MapUtils.computeIfAbsent(cache, Objects.hash(resolverGroup, recorder), key -> new AddressResolverGroupMetrics(resolverGroup, recorder));
    }

    AddressResolverGroupMetrics(AddressResolverGroup<T> resolverGroup, ChannelMetricsRecorder recorder) {
        this.resolverGroup = resolverGroup;
        this.recorder = recorder;
    }

    protected AddressResolver<T> newResolver(EventExecutor executor) {
        return new DelegatingAddressResolver(this.recorder, this.resolverGroup.getResolver(executor));
    }

    static class DelegatingAddressResolver<T extends SocketAddress>
    implements AddressResolver<T> {
        final ChannelMetricsRecorder recorder;
        final AddressResolver<T> resolver;

        DelegatingAddressResolver(ChannelMetricsRecorder recorder, AddressResolver<T> resolver) {
            this.recorder = recorder;
            this.resolver = resolver;
        }

        public boolean isSupported(SocketAddress address) {
            return this.resolver.isSupported(address);
        }

        public boolean isResolved(SocketAddress address) {
            return this.resolver.isResolved(address);
        }

        public Future<T> resolve(SocketAddress address) {
            return this.resolveInternal(address, () -> this.resolver.resolve(address));
        }

        public Future<T> resolve(SocketAddress address, Promise<T> promise) {
            return this.resolveInternal(address, () -> this.resolver.resolve(address, promise));
        }

        public Future<List<T>> resolveAll(SocketAddress address) {
            return this.resolveAllInternal(address, () -> this.resolver.resolveAll(address));
        }

        public Future<List<T>> resolveAll(SocketAddress address, Promise<List<T>> promise) {
            return this.resolveAllInternal(address, () -> this.resolver.resolveAll(address, promise));
        }

        public void close() {
            this.resolver.close();
        }

        Future<T> resolveInternal(SocketAddress address, Supplier<Future<T>> resolver) {
            long resolveTimeStart = System.nanoTime();
            return resolver.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
        }

        Future<List<T>> resolveAllInternal(SocketAddress address, Supplier<Future<List<T>>> resolver) {
            long resolveTimeStart = System.nanoTime();
            return resolver.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
        }

        void record(long resolveTimeStart, String status, SocketAddress remoteAddress) {
            block2: {
                try {
                    this.recorder.recordResolveAddressTime(remoteAddress, Duration.ofNanos(System.nanoTime() - resolveTimeStart), status);
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn("Exception caught while recording metrics.", (Throwable)e);
                }
            }
        }
    }
}

