/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.search.matchhighlight.CharSequenceIterator;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.Passage;
import org.apache.lucene.search.matchhighlight.PassageAdjuster;

public class BreakIteratorShrinkingAdjuster
implements PassageAdjuster {
    private final BreakIterator bi;
    private CharSequence value;

    public BreakIteratorShrinkingAdjuster() {
        this(BreakIterator.getWordInstance(Locale.ROOT));
    }

    public BreakIteratorShrinkingAdjuster(BreakIterator bi) {
        this.bi = bi;
    }

    @Override
    public void currentValue(CharSequence value) {
        this.value = value;
        this.bi.setText(new CharSequenceIterator(value));
    }

    @Override
    public OffsetRange adjust(Passage passage) {
        int to;
        int from = passage.from;
        if (from > 0) {
            while (!this.bi.isBoundary(from) || from < this.value.length() && Character.isWhitespace(this.value.charAt(from))) {
                if ((from = this.bi.following(from)) != -1) continue;
                from = passage.from;
                break;
            }
            if (from == this.value.length()) {
                from = passage.from;
            }
        }
        if ((to = passage.to) != this.value.length()) {
            while (!this.bi.isBoundary(to) || to > 0 && Character.isWhitespace(this.value.charAt(to - 1))) {
                if ((to = this.bi.preceding(to)) != -1) continue;
                to = passage.to;
                break;
            }
            if (to == 0) {
                to = passage.to;
            }
        }
        for (OffsetRange r : passage.markers) {
            from = Math.min(from, r.from);
            to = Math.max(to, r.to);
        }
        if (from > to) {
            from = to;
        }
        return new OffsetRange(from, to);
    }
}

