/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

public class FileWatcher
implements Runnable,
AutoCloseable {
    static final Log LOG = LogFactory.getLog(FileWatcher.class);
    public static final int SLEEP = 2000;
    private final Thread thread;
    private final ConcurrentHashMap<Path, Watched> watched = new ConcurrentHashMap();
    private boolean running = true;

    public FileWatcher() {
        this.thread = new Thread((Runnable)this, "FileWatcher");
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        this.thread.start();
    }

    public void unwatch(Path path) {
        this.watched.remove(path);
        LOG.debug("Unwatched %s", path);
    }

    public void watch(Path path, Consumer<Path> callback) {
        this.watched.compute(path, (k, w) -> {
            if (w == null) {
                w = new Watched();
                try {
                    w.lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    w.lastModified = -1L;
                    LOG.debug("File not found %s", path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            w.watchers.add(callback);
            return w;
        });
        LOG.debug("Watching %s", path);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
            if (!this.running) {
                return;
            }
            for (Map.Entry<Path, Watched> e : this.watched.entrySet()) {
                Watched w = e.getValue();
                try {
                    long lastModified = Files.getLastModifiedTime(e.getKey(), new LinkOption[0]).toMillis();
                    if (w.lastModified >= lastModified) continue;
                    w.lastModified = lastModified;
                    for (Consumer<Path> c : w.watchers) {
                        c.accept(e.getKey());
                    }
                }
                catch (FileNotFoundException | NoSuchFileException ex) {
                    w.lastModified = -1L;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public void stop() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static class Watched {
        long lastModified;
        List<Consumer<Path>> watchers = new ArrayList<Consumer<Path>>(2);

        Watched() {
        }
    }
}

