/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class MyRightsResponseEncoder
implements ImapResponseEncoder<MyRightsResponse> {
    @Override
    public Class<MyRightsResponse> acceptableMessages() {
        return MyRightsResponse.class;
    }

    @Override
    public void encode(MyRightsResponse aclResponse, ImapResponseComposer composer) throws IOException {
        composer.untagged();
        composer.commandName(ImapConstants.MYRIGHTS_COMMAND);
        Optional.ofNullable(aclResponse.getMailboxName()).ifPresent((Consumer<MailboxName>)Throwing.consumer(value -> composer.quote(value.asString())));
        Optional.ofNullable(aclResponse.getMyRights()).ifPresent((Consumer<MailboxACL.Rfc4314Rights>)Throwing.consumer(value -> composer.quote(value.serialize())));
        composer.end();
    }
}

