/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.service.ClearMailboxContentTask;
import org.apache.james.webadmin.validation.MailboxName;

public class ClearMailboxContentTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    public static final AdditionalInformationDTOModule<ClearMailboxContentTask.AdditionalInformation, ClearMailboxContentTaskAdditionalInformationDTO> SERIALIZATION_MODULE = (AdditionalInformationDTOModule)DTOModule.forDomainObject(ClearMailboxContentTask.AdditionalInformation.class).convertToDTO(ClearMailboxContentTaskAdditionalInformationDTO.class).toDomainObjectConverter(ClearMailboxContentTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(ClearMailboxContentTaskAdditionalInformationDTO::toDto).typeName(ClearMailboxContentTask.TASK_TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    private final String type;
    private final String username;
    private final String mailboxName;
    private final Instant timestamp;
    private final long messagesSuccessCount;
    private final long messagesFailCount;

    private static ClearMailboxContentTask.AdditionalInformation toDomainObject(ClearMailboxContentTaskAdditionalInformationDTO dto) {
        return new ClearMailboxContentTask.AdditionalInformation(Username.of((String)dto.getUsername()), new MailboxName(dto.getMailboxName()), dto.getTimestamp(), dto.getMessagesSuccessCount(), dto.getMessagesFailCount());
    }

    private static ClearMailboxContentTaskAdditionalInformationDTO toDto(ClearMailboxContentTask.AdditionalInformation domain, String type) {
        return new ClearMailboxContentTaskAdditionalInformationDTO(type, domain.getUsername().asString(), domain.getMailboxName().asString(), domain.getTimestamp(), domain.getMessagesSuccessCount(), domain.getMessagesFailCount());
    }

    public ClearMailboxContentTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="username") String username, @JsonProperty(value="mailboxName") String mailboxName, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="messagesSuccessCount") long messagesSuccessCount, @JsonProperty(value="messagesFailCount") long messagesFailCount) {
        this.type = type;
        this.username = username;
        this.mailboxName = mailboxName;
        this.timestamp = timestamp;
        this.messagesSuccessCount = messagesSuccessCount;
        this.messagesFailCount = messagesFailCount;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getUsername() {
        return this.username;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public long getMessagesSuccessCount() {
        return this.messagesSuccessCount;
    }

    public long getMessagesFailCount() {
        return this.messagesFailCount;
    }
}

