/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import java.util.Optional;
import org.apache.james.mailbox.indexer.ReIndexer;
import spark.Request;

public class ReindexingRunningOptionsParser {
    public static ReIndexer.RunningOptions parse(Request request) {
        return ReIndexer.RunningOptions.builder().messagesPerSeconds(ReindexingRunningOptionsParser.intQueryParameter(request, "messagesPerSecond")).mode(ReindexingRunningOptionsParser.modeQueryParameter(request, "mode")).build();
    }

    public static Optional<Integer> intQueryParameter(Request request, String queryParameter) {
        try {
            return Optional.ofNullable(request.queryParams(queryParameter)).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Illegal value supplied for query parameter '%s', expecting a strictly positive optional integer", queryParameter), e);
        }
    }

    public static Optional<ReIndexer.RunningOptions.Mode> modeQueryParameter(Request request, String queryParameter) {
        return ReIndexer.RunningOptions.parseMode((String)request.queryParams(queryParameter));
    }
}

