/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.probe.DataProbe;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.streams.Iterators;
import org.apache.james.utils.GuiceProbe;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DataProbeImpl
implements GuiceProbe,
DataProbe {
    private final DomainList domainList;
    private final UsersRepository usersRepository;
    private final RecipientRewriteTable recipientRewriteTable;
    private final DelegationStore delegationStore;

    @Inject
    private DataProbeImpl(DomainList domainList, UsersRepository usersRepository, RecipientRewriteTable recipientRewriteTable, DelegationStore delegationStore) {
        this.domainList = domainList;
        this.usersRepository = usersRepository;
        this.recipientRewriteTable = recipientRewriteTable;
        this.delegationStore = delegationStore;
    }

    public void addUser(String userName, String password) throws Exception {
        this.usersRepository.addUser(Username.of((String)userName), password);
    }

    public void removeUser(String username) throws Exception {
        this.usersRepository.removeUser(Username.of((String)username));
    }

    public String[] listUsers() throws Exception {
        return (String[])Iterators.toStream((Iterator)this.usersRepository.list()).map(Username::asString).toArray(String[]::new);
    }

    public void addDomain(String domain) throws Exception {
        this.domainList.addDomain(Domain.of((String)domain));
    }

    public boolean containsDomain(String domain) throws Exception {
        return this.domainList.containsDomain(Domain.of((String)domain));
    }

    public String getDefaultDomain() throws Exception {
        return this.domainList.getDefaultDomain().name();
    }

    public void removeDomain(String domain) throws Exception {
        this.domainList.removeDomain(Domain.of((String)domain));
    }

    public List<String> listDomains() throws Exception {
        return (List)this.domainList.getDomains().stream().map(Domain::name).collect(ImmutableList.toImmutableList());
    }

    public Map<String, Mappings> listMappings() throws Exception {
        return (Map)this.recipientRewriteTable.getAllMappings().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((MappingSource)entry.getKey()).asString(), Map.Entry::getValue));
    }

    public void addAddressMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        MappingSource source = MappingSource.fromUser((String)fromUser, (String)fromDomain);
        this.recipientRewriteTable.addAddressMapping(source, toAddress);
    }

    public void addUserAliasMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        MappingSource source = MappingSource.fromUser((String)fromUser, (String)fromDomain);
        this.recipientRewriteTable.addAliasMapping(source, toAddress);
    }

    public void removeUserAliasMapping(String fromUser, String fromDomain, String toAddress) throws Exception {
        MappingSource source = MappingSource.fromUser((String)fromUser, (String)fromDomain);
        this.recipientRewriteTable.removeAliasMapping(source, toAddress);
    }

    public void addDomainAliasMapping(String aliasDomain, String deliveryDomain) throws Exception {
        this.recipientRewriteTable.addDomainAliasMapping(MappingSource.fromDomain((Domain)Domain.of((String)aliasDomain)), Domain.of((String)deliveryDomain));
    }

    public void addMapping(MappingSource source, Mapping mapping) throws Exception {
        this.recipientRewriteTable.addMapping(source, mapping);
    }

    public void addGroupAliasMapping(String fromGroup, String toAddress) throws Exception {
        this.recipientRewriteTable.addGroupMapping(MappingSource.fromMailAddress((MailAddress)new MailAddress(fromGroup)), toAddress);
    }

    public void addAuthorizedUser(Username baseUser, Username userWithAccess) {
        Mono.from((Publisher)this.delegationStore.addAuthorizedUser(baseUser, userWithAccess)).block();
    }

    public Collection<Username> listAuthorizedUsers(Username baseUser) {
        return (Collection)Flux.from((Publisher)this.delegationStore.authorizedUsers(baseUser)).collectList().block();
    }
}

