/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable<Integer, Import> _importers;
    private String inputFileName;
    private static short skip;

    public Import(String string, String string2, String string3, String string4, int n, String string5, boolean bl, int n2, String string6, String string7) throws SQLException {
        try {
            this.inputFileName = string;
            this.noOfColumnsExpected = n;
            this.tableColumnTypesStr = string5;
            this.columnTypeNamesString = string6;
            this.udtClassNamesString = string7;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string3, string2, string4);
            this.lobsInExtFile = bl;
            _importers.put(n2, this);
            this.doImport();
        }
        catch (Exception exception) {
            throw this.importError(exception);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, short s, boolean bl, short ... sArray) throws SQLException {
        try {
            if (bl) {
                SecurityUtil.authorize(Securable.IMPORT_TABLE_LOBS_FROM_EXTFILE);
            } else {
                SecurityUtil.authorize(Securable.IMPORT_TABLE);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        if (sArray.length > 0) {
            skip = sArray[0];
            if (skip < 0) {
                throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42XAV", (Object[])new Object[0]));
            }
        } else {
            skip = 0;
        }
        Import.performImport(connection, string, null, null, string2, string3, string4, string5, string6, s, bl);
    }

    public static void importData(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s, boolean bl, short ... sArray) throws SQLException {
        try {
            if (bl) {
                SecurityUtil.authorize(Securable.IMPORT_DATA_LOBS_FROM_EXTFILE);
            } else {
                SecurityUtil.authorize(Securable.IMPORT_DATA);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        if (sArray.length > 0) {
            skip = sArray[0];
            if (skip < 0) {
                throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42XAV", (Object[])new Object[0]));
            }
        } else {
            skip = 0;
        }
        Import.performImport(connection, string, string3, string4, string2, string5, string6, string7, string8, s, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s, boolean bl) throws SQLException {
        Integer n = Import.bumpImportCounter();
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (string4 == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, string, string4, string2, string3, "COLUMN", Import.readHeaders(string5, string7, string6, string8));
            String string9 = null;
            String string10 = null;
            try {
                string9 = columnInfo.getColumnTypeNames();
                string10 = columnInfo.getUDTClassNames();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError(_importers.get(n), string5, throwable);
            }
            StringBuffer stringBuffer = new StringBuffer("new ");
            stringBuffer.append("org.apache.derby.impl.load.Import");
            stringBuffer.append("(");
            stringBuffer.append(Import.quoteStringArgument(string5));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string6));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string7));
            stringBuffer.append(",");
            stringBuffer.append(Import.quoteStringArgument(string8));
            stringBuffer.append(", ");
            stringBuffer.append(columnInfo.getExpectedNumberOfColumnsInFile());
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            stringBuffer.append(", ");
            stringBuffer.append(bl);
            stringBuffer.append(", ");
            stringBuffer.append(n);
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string9));
            stringBuffer.append(", ");
            stringBuffer.append(Import.quoteStringArgument(string10));
            stringBuffer.append(" )");
            String string11 = stringBuffer.toString();
            String string12 = IdUtil.mkQualifiedName(string, string4);
            String string13 = s > 0 ? "replace" : "bulkInsert";
            String string14 = columnInfo.getColumnNamesWithCasts();
            Object object = columnInfo.getInsertColumnNames();
            object = object != null ? "(" + (String)object + ") " : "";
            String string15 = "INSERT INTO " + string12 + (String)object + " --DERBY-PROPERTIES insertMode=" + string13 + "\n SELECT " + string14 + " from " + string11 + " AS importvti";
            PreparedStatement preparedStatement = connection.prepareStatement(string15);
            Statement statement = connection.createStatement();
            String string16 = "LOCK TABLE " + string12 + " IN EXCLUSIVE MODE";
            statement.executeUpdate(string16);
            try {
                preparedStatement.executeUpdate();
            }
            catch (Throwable throwable) {
                throw Import.formatImportError(_importers.get(n), string5, throwable);
            }
            statement.close();
            preparedStatement.close();
        }
        finally {
            _importers.remove(n);
        }
    }

    private static String[] readHeaders(String string, String string2, String string3, String string4) throws SQLException {
        try {
            if (skip > 0) {
                ControlInfo controlInfo = new ControlInfo();
                controlInfo.setControlProperties(string2, string3, string4);
                ImportReadData importReadData = new ImportReadData(string, controlInfo, 0);
                String[] stringArray = new String[importReadData.numberOfColumns];
                String[] stringArray2 = new String[importReadData.numberOfColumns];
                for (int i = 0; i < skip; ++i) {
                    importReadData.readNextRow(stringArray2);
                    for (int j = 0; j < importReadData.numberOfColumns; ++j) {
                        if (i == 0) {
                            stringArray[j] = stringArray2[j];
                            continue;
                        }
                        if (stringArray2[j] == null) continue;
                        stringArray[j] = stringArray[j] + " " + stringArray2[j];
                    }
                }
                return stringArray;
            }
            return null;
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    @Override
    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader, skip);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import import_, String string, Throwable throwable) {
        int n = -1;
        if (import_ != null) {
            n = import_.getCurrentLineNumber();
        }
        StandardException standardException = StandardException.newException((String)"XIE0R.S", (Object[])new Object[]{n, string, throwable.getMessage()});
        standardException.initCause(throwable);
        return PublicAPI.wrapStandardException((StandardException)standardException);
    }

    private static String quoteStringArgument(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string);
    }

    static {
        _importers = new Hashtable();
    }
}

