/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.derby.impl.io.CPStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.io.StorageFile;

class CPFile
extends InputStreamFile<CPStorageFactory> {
    CPFile(CPStorageFactory cPStorageFactory, String string) {
        super(cPStorageFactory, string);
    }

    CPFile(CPStorageFactory cPStorageFactory, String string, String string2) {
        super(cPStorageFactory, string, string2);
    }

    CPFile(CPFile cPFile, String string) {
        super(cPFile, string);
    }

    private CPFile(CPStorageFactory cPStorageFactory, String string, int n) {
        super(cPStorageFactory, string, n);
    }

    @Override
    public boolean exists() {
        return this.getURL() != null;
    }

    @Override
    StorageFile getParentDir(int n) {
        return new CPFile((CPStorageFactory)this.storageFactory, this.path, n);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = null;
        ClassLoader classLoader = CPFile.getContextClassLoader(Thread.currentThread());
        if (classLoader != null) {
            inputStream = CPFile.getResourceAsStream(classLoader, this.path);
        }
        if (inputStream == null) {
            classLoader = this.getClass().getClassLoader();
            inputStream = classLoader != null ? CPFile.getResourceAsStream(classLoader, this.path) : CPFile.getSystemResourceAsStream(this.path);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(this.toString());
        }
        return inputStream;
    }

    private URL getURL() {
        URL uRL;
        ClassLoader classLoader = CPFile.getContextClassLoader(Thread.currentThread());
        if (classLoader != null && (uRL = CPFile.getResource(classLoader, this.path)) != null) {
            return uRL;
        }
        classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return CPFile.getResource(classLoader, this.path);
        }
        return CPFile.getSystemResource(this.path);
    }

    private static ClassLoader getContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    private static URL getResource(ClassLoader classLoader, String string) {
        return classLoader.getResource(string);
    }

    private static URL getSystemResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    private static InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        return classLoader.getResourceAsStream(string);
    }

    private static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemResourceAsStream(string);
    }
}

