/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.annotations;

import jakarta.annotation.Resource;
import jakarta.annotation.Resources;
import javax.naming.NamingException;
import org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesAnnotationHandler.class);

    public ResourcesAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        Resources resources = clazz.getAnnotation(Resources.class);
        if (resources != null) {
            Resource[] resArray = resources.value();
            if (resArray == null || resArray.length == 0) {
                LOG.warn("Skipping empty or incorrect Resources annotation on {}", (Object)clazz.getName());
                return;
            }
            for (int j = 0; j < resArray.length; ++j) {
                String name = resArray[j].name();
                String mappedName = resArray[j].mappedName();
                if (name == null || name.trim().isEmpty()) {
                    throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
                }
                try {
                    if (NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName) || NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName)) continue;
                    LOG.warn("Skipping Resources(Resource) annotation on {} for name {}: no resource bound at {}", new Object[]{clazz.getName(), name, mappedName == null ? name : mappedName});
                    continue;
                }
                catch (NamingException e) {
                    LOG.warn("Unable to bind {} to {}", new Object[]{name, mappedName, e});
                }
            }
        }
    }
}

