/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.xmlstore;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.xmlstore.ObjectData;
import org.apache.openjpa.xmlstore.XMLConfiguration;
import org.apache.openjpa.xmlstore.XMLFileHandler;

public class XMLStore {
    private final XMLConfiguration _conf;
    private final Map _metaOidMaps = new HashMap();
    private boolean _locked;

    public XMLStore(XMLConfiguration conf) {
        this._conf = conf;
    }

    public synchronized ObjectData getData(ClassMetaData meta, Object oid) {
        meta = XMLStore.getLeastDerived(meta);
        return (ObjectData)this.getMap(meta).get(oid);
    }

    public synchronized ObjectData[] getData(ClassMetaData meta) {
        meta = XMLStore.getLeastDerived(meta);
        Collection vals = this.getMap(meta).values();
        return vals.toArray(new ObjectData[vals.size()]);
    }

    private Map getMap(ClassMetaData meta) {
        HashMap<Object, ObjectData> m = (HashMap<Object, ObjectData>)this._metaOidMaps.get(meta);
        if (m != null) {
            return m;
        }
        Collection datas = this._conf.getFileHandler().load(meta);
        m = new HashMap<Object, ObjectData>(datas.size());
        for (Object o : datas) {
            ObjectData data = (ObjectData)o;
            m.put(data.getId(), data);
        }
        this._metaOidMaps.put(meta, m);
        return m;
    }

    private static ClassMetaData getLeastDerived(ClassMetaData meta) {
        while (meta.getPCSuperclass() != null) {
            meta = meta.getPCSuperclassMetaData();
        }
        return meta;
    }

    public synchronized void beginTransaction() {
        while (this._locked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this._locked = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endTransaction(Collection<ObjectData> updates, Collection<ObjectData> deletes) {
        HashSet<ClassMetaData> dirty = new HashSet<ClassMetaData>();
        try {
            if (updates != null) {
                for (ObjectData data : updates) {
                    ClassMetaData classMetaData = XMLStore.getLeastDerived(data.getMetaData());
                    this.getMap(classMetaData).put(data.getId(), data);
                    dirty.add(classMetaData);
                }
            }
            if (deletes != null) {
                for (ObjectData data : deletes) {
                    ClassMetaData classMetaData = XMLStore.getLeastDerived(data.getMetaData());
                    this.getMap(classMetaData).remove(data.getId());
                    dirty.add(classMetaData);
                }
            }
            XMLFileHandler fh = this._conf.getFileHandler();
            for (Object e : dirty) {
                ClassMetaData meta2 = (ClassMetaData)e;
                fh.store(meta2, this.getMap(meta2).values());
            }
        }
        finally {
            this.notify();
            this._locked = false;
        }
    }
}

