/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIteratorChain;
import org.apache.openjpa.lib.meta.ZipFileMetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.StringUtil;

public class ClasspathMetaDataIterator
extends MetaDataIteratorChain {
    public ClasspathMetaDataIterator() throws IOException {
        this((String[])null, (MetaDataFilter)null);
    }

    public ClasspathMetaDataIterator(String[] dirs, MetaDataFilter filter) throws IOException {
        String[] tokens;
        Properties props = AccessController.doPrivileged(J2DoPrivHelper.getPropertiesAction());
        String path = props.getProperty("java.class.path");
        for (String token : tokens = StringUtil.split(path, props.getProperty("path.separator"), 0)) {
            File file;
            if (dirs != null && dirs.length != 0 && !ClasspathMetaDataIterator.endsWith(token, dirs) || !AccessController.doPrivileged(J2DoPrivHelper.existsAction(file = new File(token))).booleanValue()) continue;
            if (AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction(file)).booleanValue()) {
                this.addIterator(new FileMetaDataIterator(file, filter));
                continue;
            }
            if (!token.endsWith(".jar")) continue;
            try {
                ZipFile zFile = AccessController.doPrivileged(J2DoPrivHelper.newZipFileAction(file));
                this.addIterator(new ZipFileMetaDataIterator(zFile, filter));
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
    }

    private static boolean endsWith(String token, String[] suffs) {
        for (String suff : suffs) {
            if (!token.endsWith(suff)) continue;
            return true;
        }
        return false;
    }
}

