/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionForceConsumerDelivery
extends PacketImpl {
    private long consumerID;
    private long sequence;

    public SessionForceConsumerDelivery(long consumerID, long sequence) {
        super((byte)78);
        this.consumerID = consumerID;
        this.sequence = sequence;
    }

    public SessionForceConsumerDelivery() {
        super((byte)78);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.sequence);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.sequence = buffer.readLong();
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", consumerID=" + this.consumerID);
        sb.append(", sequence=" + this.sequence);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionForceConsumerDelivery)) {
            return false;
        }
        SessionForceConsumerDelivery other = (SessionForceConsumerDelivery)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        return this.sequence == other.sequence;
    }
}

