/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface AddressControl {
    public static final String ROUTED_MESSAGE_COUNT_DESCRIPTION = "number of messages routed to one or more bindings";
    public static final String UNROUTED_MESSAGE_COUNT_DESCRIPTION = "number of messages not routed to any bindings";
    public static final String ADDRESS_SIZE_DESCRIPTION = "the number of estimated bytes being used by all the queue(s) bound to this address; used to control paging and blocking";
    public static final String NUMBER_OF_PAGES_DESCRIPTION = "number of pages used by this address";
    public static final String LIMIT_PERCENT_DESCRIPTION = "the % of memory limit (global or local) that is in use by this address";

    @Attribute(desc="the internal ID of this address")
    public long getId();

    @Attribute(desc="the name of this address")
    public String getAddress();

    @Attribute(desc="the routing types enabled on this address")
    public String[] getRoutingTypes();

    @Attribute(desc="the routing types enabled on this address as JSON")
    public String getRoutingTypesAsJSON();

    @Attribute(desc="roles (name and permissions) associated with this address")
    public Object[] getRoles() throws Exception;

    @Attribute(desc="roles (name and permissions) associated with this address using JSON serialization")
    public String getRolesAsJSON() throws Exception;

    @Attribute(desc="the number of estimated bytes being used by all the queue(s) bound to this address; used to control paging and blocking")
    public long getAddressSize();

    @Attribute(desc="The maximum number of bytes that can be read into memory from paged files")
    public int getMaxPageReadBytes();

    @Attribute(desc="The maximum number of messages that can be read into memory from paged files")
    public int getMaxPageReadMessages();

    @Attribute(desc="The number of bytes to prefetch from storage into memory before reching maxReadBytes")
    public int getPrefetchPageBytes();

    @Attribute(desc="The number of messages prefetch from storage into memory before reching maxReadBytes")
    public int getPrefetchPageMessages();

    @Operation(desc="Schedule Page Cleanup on this address")
    public void schedulePageCleanup() throws Exception;

    @Deprecated
    @Attribute(desc="the sum of messages on queue(s), including messages in delivery; DEPRECATED: use getMessageCount() instead")
    public long getNumberOfMessages();

    @Attribute(desc="names of the remote queue(s) bound to this address")
    public String[] getRemoteQueueNames();

    @Attribute(desc="names of the local queue(s) bound to this address")
    public String[] getQueueNames();

    @Attribute(desc="names of both the local & remote queue(s) bound to this address")
    public String[] getAllQueueNames();

    @Attribute(desc="number of pages used by this address")
    public long getNumberOfPages();

    @Attribute(desc="whether this address is paging")
    public boolean isPaging() throws Exception;

    @Attribute(desc="the % of memory limit (global or local) that is in use by this address")
    public int getAddressLimitPercent();

    @Operation(desc="Stops message production to this address, typically with flow control.", impact=1)
    public boolean block() throws Exception;

    @Operation(desc="Resumes message production to this address, if previously blocked.", impact=1)
    public void unblock() throws Exception;

    @Attribute(desc="number of bytes used by each page for this address")
    public long getNumberOfBytesPerPage() throws Exception;

    @Attribute(desc="names of all bindings (both queues and diverts) bound to this address")
    public String[] getBindingNames() throws Exception;

    @Attribute(desc="number of local queues bound to this address")
    public long getQueueCount();

    @Attribute(desc="number of messages currently in all queues bound to this address (includes scheduled, paged, and in-delivery messages)")
    public long getMessageCount();

    @Attribute(desc="number of messages routed to one or more bindings")
    public long getRoutedMessageCount();

    @Attribute(desc="number of messages not routed to any bindings")
    public long getUnRoutedMessageCount();

    @Operation(desc="Sends a TextMessage to a password-protected address.", impact=1)
    public String sendMessage(@Parameter(name="headers", desc="The headers to add to the message") Map<String, String> var1, @Parameter(name="type", desc="A type for the message") int var2, @Parameter(name="body", desc="The body (byte[]) of the message encoded as a string using Base64") String var3, @Parameter(name="durable", desc="Whether the message is durable") boolean var4, @Parameter(name="user", desc="The user to authenticate with") String var5, @Parameter(name="password", desc="The users password to authenticate with") String var6) throws Exception;

    @Operation(desc="Sends a TextMessage to a password-protected address.", impact=1)
    public String sendMessage(@Parameter(name="headers", desc="The headers to add to the message") Map<String, String> var1, @Parameter(name="type", desc="A type for the message") int var2, @Parameter(name="body", desc="The body (byte[]) of the message encoded as a string using Base64") String var3, @Parameter(name="durable", desc="Whether the message is durable") boolean var4, @Parameter(name="user", desc="The user to authenticate with") String var5, @Parameter(name="password", desc="The users password to authenticate with") String var6, @Parameter(name="createMessageId", desc="whether or not to auto generate a Message ID") boolean var7) throws Exception;

    @Operation(desc="Pauses the queues bound to this address", impact=1)
    public void pause() throws Exception;

    @Operation(desc="Pauses the queues bound to this address", impact=1)
    public void pause(@Parameter(name="persist", desc="if true, the pause state will be persisted.") boolean var1) throws Exception;

    @Operation(desc="Resumes the queues bound to this address", impact=1)
    public void resume() throws Exception;

    @Attribute(desc="indicates if the queues bound to this address are paused")
    public boolean isPaused();

    @Attribute(desc="whether this address is used for a retroactive address")
    public boolean isRetroactiveResource();

    @Attribute(desc="the size of the duplicate ID cache for this address")
    public long getCurrentDuplicateIdCacheSize();

    @Attribute(desc="clear the duplicate ID cache for this address both from memory and from the journal")
    public boolean clearDuplicateIdCache() throws Exception;

    @Attribute(desc="whether this address was created automatically in response to client action")
    public boolean isAutoCreated();

    @Attribute(desc="whether this address was created for the broker's internal use")
    public boolean isInternal();

    @Attribute(desc="whether this address is temporary")
    public boolean isTemporary();

    @Operation(desc="Purges the queues bound to this address. Returns the total number of messages purged.", impact=1)
    public long purge() throws Exception;

    @Operation(desc="Replays messages from all files in the retention folder that match an address and filter.", impact=1)
    public void replay(@Parameter(name="target", desc="Where the replay data should be sent") String var1, @Parameter(name="filter", desc="Filter to apply on message selection. Null means everything matching the address") String var2) throws Exception;

    @Operation(desc="Replays messages from a configurable subset of the files in the retention folder that match an address and filter.", impact=1)
    public void replay(@Parameter(name="startScanDate", desc="Start date where we will start scanning for journals to replay. Format YYYYMMDDHHMMSS") String var1, @Parameter(name="endScanDate", desc="Finish date where we will stop scannning for journals to replay. Format YYYYMMDDHHMMSS") String var2, @Parameter(name="target", desc="Where the replay data should be sent") String var3, @Parameter(name="filter", desc="Filter to apply on message selection. Null means everything matching the address") String var4) throws Exception;
}

