/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Function;

public class MailboxConstants {
    public static final char NAMESPACE_PREFIX_CHAR = '#';
    public static final String USER_NAMESPACE = "#private";
    public static char FOLDER_DELIMITER = Optional.ofNullable(System.getProperty((String)"james.mailbox.folder.delimiter")).map((Function<String, MailboxFolderDelimiter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, parse(java.lang.String ), (Ljava/lang/String;)Lorg/apache/james/mailbox/model/MailboxConstants$MailboxFolderDelimiter;)()).orElse((MailboxFolderDelimiter)MailboxFolderDelimiter.DOT).value;
    public static final String INBOX = "INBOX";
    public static final int DEFAULT_LIMIT_ANNOTATION_SIZE = 1024;
    public static final int DEFAULT_LIMIT_ANNOTATIONS_ON_MAILBOX = 10;

    public static enum MailboxFolderDelimiter {
        DOT('.'),
        SLASH('/'),
        PIPE('|'),
        COMMA(','),
        COLON(':'),
        SEMICOLON(';');

        public final char value;

        private MailboxFolderDelimiter(char value) {
            this.value = value;
        }

        static MailboxFolderDelimiter parse(String input) {
            for (MailboxFolderDelimiter delimiter : MailboxFolderDelimiter.values()) {
                if (!delimiter.name().equalsIgnoreCase(input)) continue;
                return delimiter;
            }
            throw new IllegalArgumentException(String.format("Invalid mailbox delimiter `%s`", input));
        }
    }
}

