/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.tests;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.tests.RecordingMetric;
import org.apache.james.metrics.tests.RecordingTimeMetric;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RecordingMetricFactory
implements MetricFactory {
    private final Multimap<String, Duration> executionTimes = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final ConcurrentHashMap<String, AtomicInteger> counters = new ConcurrentHashMap();

    public Metric generate(String name) {
        return new RecordingMetric(this.atomicCounterFor(name));
    }

    private AtomicInteger atomicCounterFor(String name) {
        return this.counters.computeIfAbsent(name, currentName -> new AtomicInteger());
    }

    public TimeMetric timer(String name) {
        return new RecordingTimeMetric(name, executionTime -> {
            Multimap<String, Duration> multimap = this.executionTimes;
            synchronized (multimap) {
                this.executionTimes.put((Object)name, executionTime);
            }
        });
    }

    public <T> Publisher<T> decoratePublisherWithTimerMetric(String name, Publisher<T> publisher) {
        return Flux.using(() -> this.timer(name), any -> publisher, TimeMetric::stopAndPublish);
    }

    public <T> Publisher<T> decoratePublisherWithTimerMetricLogP99(String name, Publisher<T> publisher) {
        return Flux.using(() -> this.timer(name), any -> publisher, timer -> timer.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Duration> executionTimesFor(String name) {
        Multimap<String, Duration> multimap = this.executionTimes;
        synchronized (multimap) {
            return this.executionTimes.get((Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<String, Duration> executionTimesForPrefixName(String prefixName) {
        Multimap<String, Duration> multimap = this.executionTimes;
        synchronized (multimap) {
            return Multimaps.filterKeys(this.executionTimes, key -> key.startsWith(prefixName));
        }
    }

    public int countFor(String name) {
        return this.atomicCounterFor(name).get();
    }

    public Map<String, Integer> countForPrefixName(String prefixName) {
        return (Map)this.counters.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefixName)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((AtomicInteger)e.getValue()).get()));
    }
}

