/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.apache.james.transport.mailets.ContentReplacer;
import org.apache.james.transport.mailets.PatternExtractor;
import org.apache.james.transport.mailets.ReplaceConfig;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

public class ReplaceContent
extends GenericMailet {
    private static final String PARAMETER_NAME_SUBJECT_PATTERN = "subjectPattern";
    private static final String PARAMETER_NAME_BODY_PATTERN = "bodyPattern";
    private static final String PARAMETER_NAME_SUBJECT_PATTERNFILE = "subjectPatternFile";
    private static final String PARAMETER_NAME_BODY_PATTERNFILE = "bodyPatternFile";
    private static final String PARAMETER_NAME_CHARSET = "charset";
    private Optional<Charset> charset;
    private boolean debug;
    @VisibleForTesting
    ReplaceConfig replaceConfig;

    public String getMailetInfo() {
        return "ReplaceContent";
    }

    public void init() throws MailetException {
        this.charset = this.initCharset();
        this.debug = this.isDebug();
        this.replaceConfig = this.initPatterns();
    }

    private Optional<Charset> initCharset() {
        String charsetName = this.getInitParameter(PARAMETER_NAME_CHARSET);
        if (Strings.isNullOrEmpty((String)charsetName)) {
            return Optional.empty();
        }
        return Optional.of(Charset.forName(charsetName));
    }

    private boolean isDebug() {
        return Integer.parseInt(this.getInitParameter("debug", "0")) == 1;
    }

    private ReplaceConfig initPatterns() throws MailetException {
        try {
            return ReplaceConfig.builder().addAllSubjectReplacingUnits(this.subjectPattern()).addAllBodyReplacingUnits(this.bodyPattern()).addAllSubjectReplacingUnits(this.subjectPatternFile()).addAllBodyReplacingUnits(this.bodyPatternFile()).build();
        }
        catch (IOException | MailetException e) {
            throw new MailetException("Failed initialization", (Exception)e);
        }
    }

    private List<ReplacingPattern> subjectPattern() throws MailetException {
        String pattern = this.getInitParameter(PARAMETER_NAME_SUBJECT_PATTERN);
        if (pattern != null) {
            return new PatternExtractor().getPatternsFromString(pattern);
        }
        return ImmutableList.of();
    }

    private List<ReplacingPattern> bodyPattern() throws MailetException {
        String pattern = this.getInitParameter(PARAMETER_NAME_BODY_PATTERN);
        if (pattern != null) {
            return new PatternExtractor().getPatternsFromString(pattern);
        }
        return ImmutableList.of();
    }

    private List<ReplacingPattern> subjectPatternFile() throws MailetException, IOException {
        String filePattern = this.getInitParameter(PARAMETER_NAME_SUBJECT_PATTERNFILE);
        if (filePattern != null) {
            return new PatternExtractor().getPatternsFromFileList(filePattern);
        }
        return ImmutableList.of();
    }

    private List<ReplacingPattern> bodyPatternFile() throws MailetException, IOException {
        String filePattern = this.getInitParameter(PARAMETER_NAME_BODY_PATTERNFILE);
        if (filePattern != null) {
            return new PatternExtractor().getPatternsFromFileList(filePattern);
        }
        return ImmutableList.of();
    }

    public void service(Mail mail) throws MailetException {
        new ContentReplacer(this.debug).replaceMailContentAndSubject(mail, this.replaceConfig, this.charset);
    }
}

