/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Iterator;
import org.eclipse.jetty.util.LegacyQuotedStringTokenizer;
import org.eclipse.jetty.util.RFC9110QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;

public interface QuotedStringTokenizer {
    public static final QuotedStringTokenizer CSV = QuotedStringTokenizer.builder().delimiters(",").ignoreOptionalWhiteSpace().build();

    public static Builder builder() {
        return new Builder();
    }

    public static boolean isQuoted(String s) {
        return s != null && s.length() > 0 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    default public String quote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "\"\"";
        }
        StringBuffer b = new StringBuffer(s.length() + 8);
        this.quote(b, s);
        return b.toString();
    }

    public void quote(Appendable var1, String var2);

    public String unquote(String var1);

    public Iterator<String> tokenize(String var1);

    public boolean needsQuoting(char var1);

    public String quoteIfNeeded(String var1);

    public void quoteIfNeeded(StringBuilder var1, String var2);

    public static class Builder {
        private String _delim;
        private boolean _returnQuotes;
        private boolean _returnDelimiters;
        private boolean _optionalWhiteSpace;
        private boolean _embeddedQuotes;
        private boolean _singleQuotes;
        private boolean _escapeOnlyQuote;
        private boolean _legacy;

        private Builder() {
        }

        public Builder delimiters(String delim) {
            this._delim = delim;
            return this;
        }

        public Builder returnQuotes() {
            this._returnQuotes = true;
            return this;
        }

        public Builder returnDelimiters() {
            this._returnDelimiters = true;
            return this;
        }

        public Builder ignoreOptionalWhiteSpace() {
            this._optionalWhiteSpace = true;
            return this;
        }

        public Builder allowEmbeddedQuotes() {
            this._embeddedQuotes = true;
            return this;
        }

        public Builder allowSingleQuote() {
            this._singleQuotes = true;
            return this;
        }

        public Builder allowEscapeOnlyForQuotes() {
            this._escapeOnlyQuote = true;
            return this;
        }

        public Builder legacy() {
            this._legacy = true;
            this._embeddedQuotes = true;
            return this;
        }

        public QuotedStringTokenizer build() {
            if (this._legacy) {
                if (this._optionalWhiteSpace) {
                    throw new IllegalArgumentException("OWS not supported by legacy");
                }
                if (this._escapeOnlyQuote) {
                    throw new IllegalArgumentException("EscapeOnlyQuote not supported by legacy");
                }
                if (!this._embeddedQuotes) {
                    throw new IllegalArgumentException("EmbeddedQuotes must be used with legacy");
                }
                return new LegacyQuotedStringTokenizer(this._delim, this._returnDelimiters, this._returnQuotes, this._singleQuotes);
            }
            if (StringUtil.isEmpty(this._delim)) {
                throw new IllegalArgumentException("Delimiters must be provided");
            }
            if (this._singleQuotes) {
                throw new IllegalArgumentException("Single quotes not supported by RFC9110");
            }
            return new RFC9110QuotedStringTokenizer(this._delim, this._optionalWhiteSpace, this._returnDelimiters, this._returnQuotes, this._embeddedQuotes, this._escapeOnlyQuote);
        }
    }
}

