/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.sieve.cassandra.model.Script;
import org.apache.james.sieve.cassandra.tables.CassandraSieveTable;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraSieveDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertScriptStatement;
    private final PreparedStatement selectScriptsStatement;
    private final PreparedStatement selectScriptStatement;
    private final PreparedStatement updateScriptActivationStatement;
    private final PreparedStatement deleteScriptStatement;

    @Inject
    public CassandraSieveDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertScriptStatement = session.prepare(QueryBuilder.insertInto((String)"sieve").value(CassandraSieveTable.USER_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.USER_NAME)).value(CassandraSieveTable.SCRIPT_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SCRIPT_NAME)).value(CassandraSieveTable.SCRIPT_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SCRIPT_CONTENT)).value(CassandraSieveTable.IS_ACTIVE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.IS_ACTIVE)).value(CassandraSieveTable.SIZE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SIZE)).build());
        this.selectScriptsStatement = session.prepare(this.getScriptsQuery().build());
        this.selectScriptStatement = session.prepare(((Select)this.getScriptsQuery().whereColumn(CassandraSieveTable.SCRIPT_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SCRIPT_NAME))).build());
        this.updateScriptActivationStatement = session.prepare(((Update)((Update)((Update)QueryBuilder.update((String)"sieve").setColumn(CassandraSieveTable.IS_ACTIVE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.IS_ACTIVE)).whereColumn(CassandraSieveTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.USER_NAME))).whereColumn(CassandraSieveTable.SCRIPT_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SCRIPT_NAME))).ifExists()).build());
        this.deleteScriptStatement = session.prepare(((Delete)((Delete)((Delete)QueryBuilder.deleteFrom((String)"sieve").whereColumn(CassandraSieveTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.USER_NAME))).whereColumn(CassandraSieveTable.SCRIPT_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.SCRIPT_NAME))).ifExists()).build());
    }

    private Select getScriptsQuery() {
        return (Select)QueryBuilder.selectFrom((String)"sieve").columns(new CqlIdentifier[]{CassandraSieveTable.SCRIPT_CONTENT, CassandraSieveTable.IS_ACTIVE, CassandraSieveTable.SCRIPT_NAME, CassandraSieveTable.SIZE}).whereColumn(CassandraSieveTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveTable.USER_NAME));
    }

    public Mono<Void> insertScript(Username username, Script script) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertScriptStatement.bind(new Object[0]).setString(CassandraSieveTable.USER_NAME, username.asString())).setString(CassandraSieveTable.SCRIPT_NAME, script.getName().getValue())).setString(CassandraSieveTable.SCRIPT_CONTENT, script.getContent().getValue())).setBoolean(CassandraSieveTable.IS_ACTIVE, script.isActive())).setLong(CassandraSieveTable.SIZE, script.getSize()));
    }

    public Flux<ScriptSummary> listScripts(Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectScriptsStatement.bind(new Object[0]).setString(CassandraSieveTable.USER_NAME, username.asString())).map(row -> new ScriptSummary(new ScriptName(row.getString(CassandraSieveTable.SCRIPT_NAME)), row.getBoolean(CassandraSieveTable.IS_ACTIVE), row.getLong(CassandraSieveTable.SIZE)));
    }

    public Mono<Boolean> updateScriptActivation(Username username, ScriptName scriptName, boolean active) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)this.updateScriptActivationStatement.bind(new Object[0]).setString(CassandraSieveTable.USER_NAME, username.asString())).setString(CassandraSieveTable.SCRIPT_NAME, scriptName.getValue())).setBoolean(CassandraSieveTable.IS_ACTIVE, active));
    }

    public Mono<Script> getScript(Username username, ScriptName name) {
        return this.getScriptRow(username, name).map(row -> Script.builder().content(row.getString(CassandraSieveTable.SCRIPT_CONTENT)).isActive(row.getBoolean(CassandraSieveTable.IS_ACTIVE)).name(name).size(row.getLong(CassandraSieveTable.SIZE)).build());
    }

    public Mono<Boolean> deleteScriptInCassandra(Username username, ScriptName name) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)((BoundStatement)this.deleteScriptStatement.bind(new Object[0]).setString(CassandraSieveTable.USER_NAME, username.asString())).setString(CassandraSieveTable.SCRIPT_NAME, name.getValue()));
    }

    private Mono<Row> getScriptRow(Username username, ScriptName name) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)this.selectScriptStatement.bind(new Object[0]).setString(CassandraSieveTable.USER_NAME, username.asString())).setString(CassandraSieveTable.SCRIPT_NAME, name.getValue()));
    }
}

