/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.collection;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class QueryPlanBase
extends AbstractQueue<Node>
implements QueryPlan {
    private final AtomicInteger nextIndex = new AtomicInteger();

    protected abstract Object[] getNodes();

    @Override
    @Nullable
    public Node poll() {
        Object[] nodes;
        int i = this.nextIndex.getAndIncrement();
        return i >= (nodes = this.getNodes()).length ? null : (Node)nodes[i];
    }

    @Override
    @NonNull
    public Iterator<Node> iterator() {
        Object[] nodes;
        int i = this.nextIndex.get();
        if (i >= (nodes = this.getNodes()).length) {
            return Collections.emptyIterator();
        }
        return Iterators.forArray((Object[])((Node[])Arrays.copyOfRange(nodes, i, nodes.length, Node[].class)));
    }

    @Override
    public int size() {
        return Math.max(this.getNodes().length - this.nextIndex.get(), 0);
    }
}

