/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public interface TupleType
extends DataType {
    @NonNull
    public List<DataType> getComponentTypes();

    @NonNull
    public TupleValue newValue();

    @NonNull
    public TupleValue newValue(Object ... var1);

    @NonNull
    public AttachmentPoint getAttachmentPoint();

    @Override
    @NonNull
    default public String asCql(boolean includeFrozen, boolean pretty) {
        StringBuilder builder = new StringBuilder();
        if (includeFrozen) {
            builder.append("frozen<");
        }
        boolean first = true;
        for (DataType type : this.getComponentTypes()) {
            builder.append(first ? "tuple<" : ", ");
            first = false;
            builder.append(type.asCql(includeFrozen, pretty));
        }
        builder.append('>');
        if (includeFrozen) {
            builder.append('>');
        }
        return builder.toString();
    }

    @Override
    default public int getProtocolCode() {
        return 49;
    }
}

