/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.esri.core.geometry.ogc.OGCLineString;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.List;

public interface LineString
extends Geometry {
    @NonNull
    public static LineString fromWellKnownText(@NonNull String source) {
        return new DefaultLineString(DefaultGeometry.fromOgcWellKnownText(source, OGCLineString.class));
    }

    @NonNull
    public static LineString fromWellKnownBinary(@NonNull ByteBuffer source) {
        return new DefaultLineString(DefaultGeometry.fromOgcWellKnownBinary(source, OGCLineString.class));
    }

    @NonNull
    public static LineString fromGeoJson(@NonNull String source) {
        return new DefaultLineString(DefaultGeometry.fromOgcGeoJson(source, OGCLineString.class));
    }

    @NonNull
    public static LineString fromPoints(@NonNull Point p1, @NonNull Point p2, Point ... pn) {
        return new DefaultLineString(p1, p2, pn);
    }

    @NonNull
    public List<Point> getPoints();
}

