/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.util.Date;
import java.util.GregorianCalendar;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GeneralizedTimeLogFieldSyntax
extends LogFieldSyntax<Date> {
    @NotNull
    public static final String SYNTAX_NAME = "generalized-time";
    @NotNull
    private static final String REDACTED_GENERALIZED_TIME_STRING = "99990101000000.000Z";
    private static final int TOKENIZED_DATE_YEAR = 8888;
    @NotNull
    private static final GeneralizedTimeLogFieldSyntax INSTANCE = new GeneralizedTimeLogFieldSyntax();

    private GeneralizedTimeLogFieldSyntax() {
        super(100);
    }

    @NotNull
    public static GeneralizedTimeLogFieldSyntax getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull Date value, @NotNull ByteStringBuffer buffer) {
        buffer.append(StaticUtils.encodeGeneralizedTime(value));
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.valueToSanitizedString(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.valueToSanitizedString(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Date value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.valueToSanitizedString(value));
    }

    @Override
    @NotNull
    public Date parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return StaticUtils.decodeGeneralizedTime(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIncludesRedactedComponent(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIncludesTokenizedComponent(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_GEN_TIME_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_GENERALIZED_TIME_STRING);
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_GENERALIZED_TIME_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(REDACTED_GENERALIZED_TIME_STRING);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, REDACTED_GENERALIZED_TIME_STRING);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString(REDACTED_GENERALIZED_TIME_STRING);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesRedactedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyRedacted(valueString);
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyRedactedFieldToTextFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedFieldToJSONFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Date value, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedValueToJSONFormattedLog(buffer);
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        if (super.valueStringIsCompletelyTokenized(valueString)) {
            return true;
        }
        return valueString.startsWith("8888");
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenizeEntireValue(@NotNull Date value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        byte[] tokenDigest;
        ByteStringBuffer tempBuffer = this.getTemporaryBuffer();
        try {
            tempBuffer.append(value.getTime());
            tempBuffer.append(pepper);
            tokenDigest = this.sha256(tempBuffer);
        }
        finally {
            this.releaseTemporaryBuffer(tempBuffer);
        }
        long tokenizedTime = 0L;
        for (int i = 0; i < 8; ++i) {
            tokenizedTime <<= 8;
            tokenizedTime |= (long)tokenDigest[i] & 0xFFL;
        }
        GregorianCalendar tokenCalendar = new GregorianCalendar(StaticUtils.getUTCTimeZone());
        tokenCalendar.setTimeInMillis(tokenizedTime);
        tokenCalendar.set(1, 8888);
        buffer.append(StaticUtils.encodeGeneralizedTime(tokenCalendar.getTime()));
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Date value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesTokenizedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyTokenized(valueString);
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyTokenizedFieldToTextFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Date fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedFieldToJSONFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Date value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedValueToJSONFormattedLog(value, pepper, buffer);
    }
}

