/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchReferenceAccessLogMessage
extends SearchRequestAccessLogMessage {
    private static final long serialVersionUID = 4413555391780641502L;
    @NotNull
    private final List<String> responseControlOIDs;
    @NotNull
    private final List<String> referralURLs;

    public SearchReferenceAccessLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public SearchReferenceAccessLogMessage(@NotNull LogMessage m) {
        super(m);
        String refStr = this.getNamedValue("referralURLs");
        if (refStr == null || refStr.isEmpty()) {
            this.referralURLs = Collections.emptyList();
        } else {
            LinkedList<String> refs = new LinkedList<String>();
            int startPos = 0;
            while (true) {
                int commaPos;
                if ((commaPos = refStr.indexOf(",ldap", startPos)) < 0) break;
                refs.add(refStr.substring(startPos, commaPos));
                startPos = commaPos + 1;
            }
            refs.add(refStr.substring(startPos));
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
    }

    @NotNull
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @NotNull
    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.REFERENCE;
    }
}

