/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00AddEntry
extends DraftChuLDAPLogSchema00Entry {
    @NotNull
    public static final String ATTR_ATTRIBUTE_CHANGES = "reqMod";
    private static final long serialVersionUID = 1236828283266120444L;
    @NotNull
    private final List<Attribute> attributes;

    public DraftChuLDAPLogSchema00AddEntry(@NotNull Entry entry) throws LDAPException {
        super(entry, OperationType.ADD);
        byte[][] changes = entry.getAttributeValueByteArrays(ATTR_ATTRIBUTE_CHANGES);
        if (changes == null || changes.length == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES));
        }
        LinkedHashMap attrMap = new LinkedHashMap(StaticUtils.computeMapCapacity(changes.length));
        for (byte[] changeBytes : changes) {
            byte[] attrValue;
            int colonPos = -1;
            for (int i = 0; i < changeBytes.length; ++i) {
                if (changeBytes[i] != 58) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_ADD_CHANGE_MISSING_COLON.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            if (colonPos == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_ADD_CHANGE_MISSING_ATTR.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            if (colonPos == changeBytes.length - 1 || changeBytes[colonPos + 1] != 43) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_ADD_CHANGE_TYPE_NOT_PLUS.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            if (colonPos == changeBytes.length - 2 || changeBytes[colonPos + 2] != 32) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_ADD_CHANGE_NO_SPACE_AFTER_PLUS.get(entry.getDN(), ATTR_ATTRIBUTE_CHANGES, StaticUtils.toUTF8String(changeBytes)));
            }
            String attrName = StaticUtils.toUTF8String(changeBytes, 0, colonPos);
            String lowerName = StaticUtils.toLowerCase(attrName);
            ArrayList<Attribute> attrList = (ArrayList<Attribute>)attrMap.get(lowerName);
            if (attrList == null) {
                attrList = new ArrayList<Attribute>(10);
                attrMap.put(lowerName, attrList);
            }
            if ((attrValue = new byte[changeBytes.length - colonPos - 3]).length > 0) {
                System.arraycopy(changeBytes, colonPos + 3, attrValue, 0, attrValue.length);
            }
            attrList.add(new Attribute(attrName, attrValue));
        }
        ArrayList<Attribute> addAttributes = new ArrayList<Attribute>(attrMap.size());
        for (List attrList : attrMap.values()) {
            if (attrList.size() == 1) {
                addAttributes.addAll(attrList);
                continue;
            }
            byte[][] valueArray = new byte[attrList.size()][];
            for (int i = 0; i < attrList.size(); ++i) {
                valueArray[i] = ((Attribute)attrList.get(i)).getValueByteArray();
            }
            addAttributes.add(new Attribute(((Attribute)attrList.get(0)).getName(), valueArray));
        }
        this.attributes = Collections.unmodifiableList(addAttributes);
    }

    @NotNull
    public List<Attribute> getAddAttributes() {
        return this.attributes;
    }

    @NotNull
    public AddRequest toAddRequest() {
        return new AddRequest(this.getTargetEntryDN(), this.attributes, this.getRequestControlArray());
    }
}

