/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftLDUPSubentriesRequestControl
extends Control {
    @NotNull
    public static final String SUBENTRIES_REQUEST_OID = "1.3.6.1.4.1.7628.5.101.1";
    private static final long serialVersionUID = 4772130172594841481L;

    public DraftLDUPSubentriesRequestControl() {
        this(false);
    }

    public DraftLDUPSubentriesRequestControl(boolean isCritical) {
        super(SUBENTRIES_REQUEST_OID, isCritical, null);
    }

    public DraftLDUPSubentriesRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SUBENTRIES_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SUBENTRIES_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", SUBENTRIES_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_SUBENTRIES_REQUEST.get()), new JSONField("criticality", this.isCritical()));
    }

    @NotNull
    public static DraftLDUPSubentriesRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, false, false);
        return new DraftLDUPSubentriesRequestControl(jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DraftLDUPSubentriesRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

