/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.memory;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.UsersRepositoryImpl;
import org.apache.james.user.memory.MemoryUsersDAO;

public class MemoryUsersRepository
extends UsersRepositoryImpl<MemoryUsersDAO> {
    public static MemoryUsersRepository withVirtualHosting(DomainList domainList) {
        MemoryUsersRepository userRepository = new MemoryUsersRepository(domainList);
        userRepository.setEnableVirtualHosting(true);
        return userRepository;
    }

    public static MemoryUsersRepository withoutVirtualHosting(DomainList domainList) {
        MemoryUsersRepository userRepository = new MemoryUsersRepository(domainList);
        userRepository.setEnableVirtualHosting(false);
        return userRepository;
    }

    private MemoryUsersRepository(DomainList domainList) {
        super(domainList, (UsersDAO)new MemoryUsersDAO());
    }

    public void clear() {
        ((MemoryUsersDAO)this.usersDAO).clear();
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        super.configure(config);
        ((MemoryUsersDAO)this.usersDAO).configure(config);
    }
}

