/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.api;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import reactor.core.publisher.Mono;

public class SieveCurrentUploadUsageCalculator {
    private final SieveRepository sieveRepository;

    @Inject
    public SieveCurrentUploadUsageCalculator(SieveRepository sieveRepository) {
        this.sieveRepository = sieveRepository;
    }

    public Mono<Void> recomputeCurrentUploadUsage(Username username) {
        return this.sieveRepository.listScriptsReactive(username).map(ScriptSummary::getSize).reduce(Long::sum).flatMap(sum -> this.sieveRepository.resetSpaceUsedReactive(username, (long)sum));
    }
}

