/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ParameterDescription
implements BackendMessage {
    private final List<Integer> parameters;

    public ParameterDescription(List<Integer> parameters) {
        this.parameters = Assert.requireNonNull(parameters, "parameters must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDescription that = (ParameterDescription)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public List<Integer> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public String toString() {
        return "ParameterDescription{parameters=" + this.parameters + '}';
    }

    static ParameterDescription decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        int count = in.readShort();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            parameters.add(in.readInt());
        }
        return new ParameterDescription(parameters);
    }
}

