/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.api;

import io.r2dbc.postgresql.api.PostgresTransactionDefinition;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class SimpleTransactionDefinition
implements PostgresTransactionDefinition {
    public static final SimpleTransactionDefinition EMPTY = new SimpleTransactionDefinition(Collections.emptyMap());
    private final Map<Option<?>, Object> options;

    SimpleTransactionDefinition(Map<Option<?>, Object> options) {
        this.options = options;
    }

    public <T> T getAttribute(Option<T> option) {
        return (T)this.options.get(option);
    }

    public PostgresTransactionDefinition with(Option<?> option, Object value) {
        HashMap options = new HashMap(this.options);
        options.put(Assert.requireNonNull(option, "option must not be null"), Assert.requireNonNull(value, "value must not be null"));
        return new SimpleTransactionDefinition(options);
    }

    @Override
    public PostgresTransactionDefinition deferrable() {
        return this.with(PostgresTransactionDefinition.DEFERRABLE, true);
    }

    @Override
    public PostgresTransactionDefinition notDeferrable() {
        return this.with(PostgresTransactionDefinition.DEFERRABLE, false);
    }

    @Override
    public PostgresTransactionDefinition isolationLevel(IsolationLevel isolationLevel) {
        return this.with(PostgresTransactionDefinition.ISOLATION_LEVEL, isolationLevel);
    }

    @Override
    public PostgresTransactionDefinition readOnly() {
        return this.with(PostgresTransactionDefinition.READ_ONLY, true);
    }

    @Override
    public PostgresTransactionDefinition readWrite() {
        return this.with(PostgresTransactionDefinition.READ_ONLY, false);
    }
}

