/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal.routing;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.internal.routing.RoutingLogic;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.routing.ConsistentHash;
import org.apache.pekko.routing.ConsistentHash$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}uA\u0002\u0012$\u0011\u0003Y\u0013G\u0002\u00044G!\u00051\u0006\u000e\u0005\u0006w\u0005!\t!\u0010\u0004\u0005}\u0005\u0011q\bC\u0003<\u0007\u0011\u0005q\nC\u0005S\u0007\u0001\u0007\t\u0019!C\u0005'\"I1l\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\nE\u000e\u0001\r\u0011!Q!\nQCqaY\u0002A\u0002\u0013%A\rC\u0004i\u0007\u0001\u0007I\u0011B5\t\r-\u001c\u0001\u0015)\u0003f\u0011\u0015a7\u0001\"\u0001n\u0011\u0015\u00018\u0001\"\u0011r\r\u0015y\u0018AAA\u0001\u0011\u0019YT\u0002\"\u0001\u0002\f!Q!+\u0004a\u0001\u0002\u0004%I!a\u0004\t\u0015mk\u0001\u0019!a\u0001\n\u0013\t)\u0002\u0003\u0006c\u001b\u0001\u0007\t\u0011)Q\u0005\u0003#Aa\u0001\\\u0007\u0005B\u0005e\u0001B\u00029\u000e\t\u0003\niB\u0002\u0004\u0002$\u0005\u0011\u0011Q\u0005\u0005\n\u0003_!\"\u0011!Q\u0001\n\u0015D!\"!\r\u0015\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\ty\u0004\u0006B\u0001B\u0003%\u0011\u0011\t\u0005\u0007wQ!\t!!\u0013\t\u0013\u0005MC\u00031A\u0005\n\u0005U\u0003\"CA0)\u0001\u0007I\u0011BA1\u0011!\t)\u0007\u0006Q!\n\u0005]\u0003\"CA4)\u0001\u0007I\u0011BA5\u0011%\t)\b\u0006a\u0001\n\u0013\t9\b\u0003\u0005\u0002|Q\u0001\u000b\u0015BA6\u0011\u0019aG\u0003\"\u0011\u0002~!1\u0001\u000f\u0006C!\u0003\u0003Cq!a\"\u0015\t\u0013\tI)A\u0007S_V$\u0018N\\4M_\u001eL7m\u001d\u0006\u0003I\u0015\nqA]8vi&twM\u0003\u0002'O\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002)S\u0005)A/\u001f9fI*\u0011!fK\u0001\u0006C\u000e$xN\u001d\u0006\u0003Y5\nQ\u0001]3lW>T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sOB\u0011!'A\u0007\u0002G\ti!k\\;uS:<Gj\\4jGN\u001c\"!A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0019\u0003\u001fI{WO\u001c3S_\nLg\u000eT8hS\u000e,\"\u0001\u0011$\u0014\u0007\r)\u0014\tE\u00023\u0005\u0012K!aQ\u0012\u0003\u0019I{W\u000f^5oO2{w-[2\u0011\u0005\u00153E\u0002\u0001\u0003\u0006\u000f\u000e\u0011\r\u0001\u0013\u0002\u0002)F\u0011\u0011\n\u0014\t\u0003m)K!aS\u001c\u0003\u000f9{G\u000f[5oOB\u0011a'T\u0005\u0003\u001d^\u00121!\u00118z)\u0005\u0001\u0006cA)\u0004\t6\t\u0011!\u0001\bdkJ\u0014XM\u001c;S_V$X-Z:\u0016\u0003Q\u00032AN+X\u0013\t1vGA\u0003BeJ\f\u0017\u0010E\u0002Y3\u0012k\u0011aJ\u0005\u00035\u001e\u0012\u0001\"Q2u_J\u0014VMZ\u0001\u0013GV\u0014(/\u001a8u%>,H/Z3t?\u0012*\u0017\u000f\u0006\u0002^AB\u0011aGX\u0005\u0003?^\u0012A!\u00168ji\"9\u0011MBA\u0001\u0002\u0004!\u0016a\u0001=%c\u0005y1-\u001e:sK:$(k\\;uK\u0016\u001c\b%A\u0004oKb$\u0018\n\u001a=\u0016\u0003\u0015\u0004\"A\u000e4\n\u0005\u001d<$aA%oi\u0006Ya.\u001a=u\u0013\u0012Dx\fJ3r)\ti&\u000eC\u0004b\u0013\u0005\u0005\t\u0019A3\u0002\u00119,\u0007\u0010^%eq\u0002\nAb]3mK\u000e$(k\\;uK\u0016$\"a\u00168\t\u000b=\\\u0001\u0019\u0001#\u0002\u00075\u001cx-\u0001\bs_V$X-Z:Va\u0012\fG/\u001a3\u0015\u0005u\u0013\b\"B:\r\u0001\u0004!\u0018A\u00038foJ{W\u000f^3fgB\u0019Q\u000f`,\u000f\u0005YT\bCA<8\u001b\u0005A(BA==\u0003\u0019a$o\\8u}%\u00111pN\u0001\u0007!J,G-\u001a4\n\u0005ut(aA*fi*\u00111p\u000e\u0002\f%\u0006tGm\\7M_\u001eL7-\u0006\u0003\u0002\u0004\u0005%1\u0003B\u00076\u0003\u000b\u0001BA\r\"\u0002\bA\u0019Q)!\u0003\u0005\u000b\u001dk!\u0019\u0001%\u0015\u0005\u00055\u0001\u0003B)\u000e\u0003\u000f)\"!!\u0005\u0011\tY*\u00161\u0003\t\u00051f\u000b9\u0001F\u0002^\u0003/A\u0001\"\u0019\t\u0002\u0002\u0003\u0007\u0011\u0011\u0003\u000b\u0005\u0003'\tY\u0002\u0003\u0004p%\u0001\u0007\u0011q\u0001\u000b\u0004;\u0006}\u0001BB:\u0014\u0001\u0004\t\t\u0003\u0005\u0003vy\u0006M!AF\"p]NL7\u000f^3oi\"\u000b7\u000f[5oO2{w-[2\u0016\t\u0005\u001d\u0012QF\n\u0005)U\nI\u0003\u0005\u00033\u0005\u0006-\u0002cA#\u0002.\u0011)q\t\u0006b\u0001\u0011\u0006\u0011b/\u001b:uk\u0006dgj\u001c3fg\u001a\u000b7\r^8s\u0003\u001di\u0017\r\u001d9j]\u001e\u0004rANA\u001b\u0003W\tI$C\u0002\u00028]\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007U\fY$C\u0002\u0002>y\u0014aa\u0015;sS:<\u0017a\u00032bg\u0016\fE\r\u001a:fgN\u0004B!a\u0011\u0002F5\t\u0011&C\u0002\u0002H%\u0012q!\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0002L\u00055\u0013qJA)!\u0011\tF#a\u000b\t\r\u0005=\u0002\u00041\u0001f\u0011\u001d\t\t\u0004\u0007a\u0001\u0003gAq!a\u0010\u0019\u0001\u0004\t\t%\u0001\u0006qCRDGk\u001c*fMN,\"!a\u0016\u0011\u000fU\fI&!\u000f\u0002^%\u0019\u00111\f@\u0003\u00075\u000b\u0007\u000f\u0005\u0003Y3\u0006-\u0012A\u00049bi\"$vNU3gg~#S-\u001d\u000b\u0004;\u0006\r\u0004\u0002C1\u001b\u0003\u0003\u0005\r!a\u0016\u0002\u0017A\fG\u000f\u001b+p%\u001647\u000fI\u0001\u000fG>t7/[:uK:$\b*Y:i+\t\tY\u0007\u0005\u0004\u0002n\u0005E\u0014\u0011H\u0007\u0003\u0003_R!\u0001J\u0016\n\t\u0005M\u0014q\u000e\u0002\u000f\u0007>t7/[:uK:$\b*Y:i\u0003I\u0019wN\\:jgR,g\u000e\u001e%bg\"|F%Z9\u0015\u0007u\u000bI\b\u0003\u0005b;\u0005\u0005\t\u0019AA6\u0003=\u0019wN\\:jgR,g\u000e\u001e%bg\"\u0004C\u0003BA/\u0003\u007fBaa\\\u0010A\u0002\u0005-BcA/\u0002\u0004\"11\u000f\ta\u0001\u0003\u000b\u0003B!\u001e?\u0002^\u0005\u0019Bo\u001c$vY2\fE\r\u001a:fgN\u001cFO]5oOR!\u0011\u0011HAF\u0011\u001d\ti)\ta\u0001\u0003;\naA]8vi\u0016,\u0007fA\u0001\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018.\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY*!&\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0004\u0001\u0005E\u0005")
@InternalApi
public final class RoutingLogics {

    public static final class ConsistentHashingLogic<T>
    implements RoutingLogic<T> {
        private final Function1<T, String> mapping;
        private final Address baseAddress;
        private Map<String, ActorRef<T>> pathToRefs;
        private ConsistentHash<String> consistentHash;

        private Map<String, ActorRef<T>> pathToRefs() {
            return this.pathToRefs;
        }

        private void pathToRefs_$eq(Map<String, ActorRef<T>> x$1) {
            this.pathToRefs = x$1;
        }

        private ConsistentHash<String> consistentHash() {
            return this.consistentHash;
        }

        private void consistentHash_$eq(ConsistentHash<String> x$1) {
            this.consistentHash = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            return (ActorRef)this.pathToRefs().apply(this.consistentHash().nodeFor((String)this.mapping.apply(msg)));
        }

        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            Map updatedPathToRefs = ((IterableOnceOps)newRoutees.map((Function1 & Serializable)routee -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toFullAddressString((ActorRef)routee)), routee))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            ConsistentHash withoutOld = (ConsistentHash)this.pathToRefs().keySet().diff((Set)updatedPathToRefs.keySet()).foldLeft(this.consistentHash(), (Function2 & Serializable)(x$3, x$4) -> x$3.$colon$minus(x$4));
            this.consistentHash_$eq((ConsistentHash<String>)((ConsistentHash)updatedPathToRefs.keySet().diff((Set)this.pathToRefs().keySet()).foldLeft((Object)withoutOld, (Function2 & Serializable)(x$5, x$6) -> x$5.$colon$plus(x$6))));
            this.pathToRefs_$eq(updatedPathToRefs);
        }

        private String toFullAddressString(ActorRef<T> routee) {
            Address address = routee.path().address();
            if (address != null) {
                Option option = address.host();
                Option option2 = address.port();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return routee.path().toStringWithAddress(this.baseAddress);
                }
            }
            return routee.path().toString();
        }

        public ConsistentHashingLogic(int virtualNodesFactor, Function1<T, String> mapping, Address baseAddress) {
            this.mapping = mapping;
            this.baseAddress = baseAddress;
            Predef$.MODULE$.require(virtualNodesFactor > 0, (Function0 & Serializable)() -> "virtualNodesFactor has to be a positive integer");
            this.pathToRefs = Predef$.MODULE$.Map().empty();
            this.consistentHash = ConsistentHash$.MODULE$.apply((Iterable)Predef$.MODULE$.Set().empty(), virtualNodesFactor, ClassTag$.MODULE$.apply(String.class));
        }
    }

    public static final class RandomLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;

        private ActorRef<T>[] currentRoutees() {
            return this.currentRoutees;
        }

        private void currentRoutees_$eq(ActorRef<T>[] x$1) {
            this.currentRoutees = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            int selectedIdx = ThreadLocalRandom.current().nextInt(this.currentRoutees().length);
            return this.currentRoutees()[selectedIdx];
        }

        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            this.currentRoutees_$eq((ActorRef[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class)));
        }
    }

    public static final class RoundRobinLogic<T>
    implements RoutingLogic<T> {
        private ActorRef<T>[] currentRoutees;
        private int nextIdx = 0;

        private ActorRef<T>[] currentRoutees() {
            return this.currentRoutees;
        }

        private void currentRoutees_$eq(ActorRef<T>[] x$1) {
            this.currentRoutees = x$1;
        }

        private int nextIdx() {
            return this.nextIdx;
        }

        private void nextIdx_$eq(int x$1) {
            this.nextIdx = x$1;
        }

        @Override
        public ActorRef<T> selectRoutee(T msg) {
            if (this.nextIdx() >= this.currentRoutees().length) {
                this.nextIdx_$eq(0);
            }
            ActorRef<T> selected = this.currentRoutees()[this.nextIdx()];
            this.nextIdx_$eq(this.nextIdx() + 1);
            return selected;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void routeesUpdated(scala.collection.immutable.Set<ActorRef<T>> newRoutees) {
            ActorRef[] sortedNewRoutees = (ActorRef[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])newRoutees.toArray(ClassTag$.MODULE$.apply(ActorRef.class))), (Function1 & Serializable)ref -> new Tuple2((Object)ref.path().toStringWithoutAddress(), (Object)ref.path().address()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, Address$.MODULE$.addressOrdering()));
            if (this.currentRoutees() != null) {
                void var3_3;
                for (int idx = 0; idx < this.currentRoutees().length && idx < sortedNewRoutees.length; ++idx) {
                    ActorRef<T> actorRef = this.currentRoutees()[idx];
                    ActorRef actorRef2 = sortedNewRoutees[idx];
                    if (actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) break;
                }
                if (this.nextIdx() > var3_3) {
                    this.nextIdx_$eq(this.nextIdx() - 1);
                }
            }
            this.currentRoutees_$eq(sortedNewRoutees);
        }
    }
}

