/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.function.Function;

public class ImmutableCollections {
    @NonNull
    public static <T> ImmutableList<T> append(@NonNull ImmutableList<T> list, @NonNull T newElement) {
        return ImmutableList.builder().addAll(list).add(newElement).build();
    }

    @NonNull
    public static <T> ImmutableList<T> concat(@NonNull ImmutableList<T> list1, @NonNull Iterable<T> list2) {
        return ImmutableList.builder().addAll(list1).addAll(list2).build();
    }

    @NonNull
    public static <T> ImmutableList<T> modifyLast(@NonNull ImmutableList<T> list, @NonNull Function<T, T> change) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            builder.add(list.get(i));
        }
        builder.add(change.apply(list.get(size - 1)));
        return builder.build();
    }

    @NonNull
    public static <K, V> ImmutableMap<K, V> append(@NonNull ImmutableMap<K, V> map, @NonNull K newKey, @NonNull V newValue) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey().equals(newKey)) continue;
            builder.put(entry);
        }
        builder.put(newKey, newValue);
        return builder.build();
    }

    @NonNull
    public static <K, V> ImmutableMap<K, V> concat(@NonNull ImmutableMap<K, V> map1, @NonNull Map<K, V> map2) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map1.entrySet()) {
            if (map2.containsKey(entry.getKey())) continue;
            builder.put(entry);
        }
        builder.putAll(map2);
        return builder.build();
    }
}

