/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.DseGraphEdgeSide;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableGraphOperationType;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import java.util.List;

public class DseTableEdgeOperation {
    private final DseTableGraphOperationType type;
    private final CqlIdentifier label;
    private final DseGraphEdgeSide from;
    private final DseGraphEdgeSide to;

    public DseTableEdgeOperation(DseTableGraphOperationType type, CqlIdentifier label, DseGraphEdgeSide from, DseGraphEdgeSide to) {
        this.type = type;
        this.label = label;
        this.from = from;
        this.to = to;
    }

    public DseTableGraphOperationType getType() {
        return this.type;
    }

    public CqlIdentifier getLabel() {
        return this.label;
    }

    public DseGraphEdgeSide getFrom() {
        return this.from;
    }

    public DseGraphEdgeSide getTo() {
        return this.to;
    }

    public void append(StringBuilder builder) {
        builder.append("EDGE LABEL");
        if (this.label != null) {
            builder.append(' ').append(this.label.asCql(true));
        }
        if (this.type == DseTableGraphOperationType.WITH) {
            builder.append(" FROM ");
            DseTableEdgeOperation.append(this.from, builder);
            builder.append(" TO ");
            DseTableEdgeOperation.append(this.to, builder);
        }
    }

    private static void append(DseGraphEdgeSide side, StringBuilder builder) {
        builder.append(side.getTableId().asCql(true)).append('(');
        List<CqlIdentifier> pkColumns = side.getPartitionKeyColumns();
        if (pkColumns.size() == 1) {
            builder.append(pkColumns.get(0).asCql(true));
        } else {
            CqlHelper.appendIds(pkColumns, builder, "(", ",", ")");
        }
        CqlHelper.appendIds(side.getClusteringColumns(), builder, ",", ",", null);
        builder.append(')');
    }
}

