/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I2a!\u0003\u0006\u0002\u00021\u0011\u0002\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\t\u0011y\u0001!\u0011!Q\u0001\nmAQa\b\u0001\u0005\u0002\u0001B\u0011\"\n\u0001A\u0002\u0003\u0005\u000b\u0015B\u000e\t\u0013\u0019\u0002\u0001\u0019!A!B\u0013Y\u0002\"B\u0014\u0001\t\u0003A\u0003\"\u0002\u0017\u0001\r\u0003i\u0003\"\u0002\u0018\u0001\t\u0003y#a\u0003+pW\u0016t')^2lKRT!a\u0003\u0007\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u001b9\tQ\u0001]3lW>T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sON\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\r\f\u0007/Y2jif\u001c\u0001\u0001\u0005\u0002\u00159%\u0011Q$\u0006\u0002\u0005\u0019>tw-\u0001\noC:|7OQ3uo\u0016,g\u000eV8lK:\u001c\u0018A\u0002\u001fj]&$h\bF\u0002\"G\u0011\u0002\"A\t\u0001\u000e\u0003)AQ!G\u0002A\u0002mAQAH\u0002A\u0002m\tq\"\u0019<bS2\f'\r\\3U_.,gn]\u0001\u000bY\u0006\u001cH/\u00169eCR,\u0017\u0001B5oSR$\u0012!\u000b\t\u0003))J!aK\u000b\u0003\tUs\u0017\u000e^\u0001\fGV\u0014(/\u001a8u)&lW-F\u0001\u001c\u0003\u0015ygMZ3s)\tY\u0002\u0007C\u00032\u0011\u0001\u00071$\u0001\u0003d_N$\b")
public abstract class TokenBucket {
    private final long capacity;
    private final long nanosBetweenTokens;
    private long availableTokens;
    private long lastUpdate;

    public void init() {
        this.availableTokens = this.capacity;
        this.lastUpdate = this.currentTime();
    }

    public abstract long currentTime();

    public long offer(long cost) {
        long l;
        if (cost < 0L) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        long now = this.currentTime();
        long timeElapsed = now - this.lastUpdate;
        if (timeElapsed >= this.nanosBetweenTokens) {
            if (timeElapsed < this.nanosBetweenTokens * 2L) {
                this.lastUpdate += this.nanosBetweenTokens;
                l = 1;
            } else {
                long tokensArrived = timeElapsed / this.nanosBetweenTokens;
                this.lastUpdate += tokensArrived * this.nanosBetweenTokens;
                l = tokensArrived;
            }
        } else {
            l = 0L;
        }
        long tokensArrived = l;
        this.availableTokens = package$.MODULE$.min(this.availableTokens + tokensArrived, this.capacity);
        if (cost <= this.availableTokens) {
            this.availableTokens -= cost;
            return 0L;
        }
        long remainingCost = cost - this.availableTokens;
        long timeSinceTokenArrival = now - this.lastUpdate;
        long delay = remainingCost * this.nanosBetweenTokens - timeSinceTokenArrival;
        this.availableTokens = 0L;
        this.lastUpdate = now + delay;
        return delay;
    }

    public TokenBucket(long capacity, long nanosBetweenTokens) {
        this.capacity = capacity;
        this.nanosBetweenTokens = nanosBetweenTokens;
        Predef$.MODULE$.require(capacity >= 0L, (Function0 & Serializable)() -> "Capacity must be non-negative.");
        Predef$.MODULE$.require(nanosBetweenTokens > 0L, (Function0 & Serializable)() -> "Time between tokens must be larger than zero nanoseconds.");
    }
}

