/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class HashCode$ {
    public static final HashCode$ MODULE$ = new HashCode$();
    private static final int SEED = 23;
    private static final int PRIME = 37;

    public int SEED() {
        return SEED;
    }

    public int hash(int seed, Object any) {
        if (any instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)any);
            return this.hash(seed, bl);
        }
        if (any instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)any);
            return this.hash(seed, c);
        }
        if (any instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)any);
            return this.hash(seed, s);
        }
        if (any instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)any);
            return this.hash(seed, n);
        }
        if (any instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)any);
            return this.hash(seed, l);
        }
        if (any instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)any);
            return this.hash(seed, f);
        }
        if (any instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)any);
            return this.hash(seed, d);
        }
        if (any instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)any);
            return this.hash(seed, by);
        }
        if (any instanceof Object) {
            IntRef result = IntRef.create((int)seed);
            if (any == null) {
                result.elem = this.hash(result.elem, 0);
            } else if (!this.isArray(any)) {
                result.elem = this.hash(result.elem, any.hashCode());
            } else {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Array.getLength(any)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
                    result$1.elem = MODULE$.hash(result$1.elem, Array.get(any, id));
                });
            }
            return result.elem;
        }
        throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected hash parameter: ").append(any).toString());
    }

    public int hash(int seed, boolean value) {
        return this.firstTerm(seed) + (value ? 1 : 0);
    }

    public int hash(int seed, char value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, int value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, long value) {
        return this.firstTerm(seed) + (int)(value ^ value >>> 32);
    }

    public int hash(int seed, float value) {
        return this.hash(seed, Float.floatToIntBits(value));
    }

    public int hash(int seed, double value) {
        return this.hash(seed, Double.doubleToLongBits(value));
    }

    private int firstTerm(int seed) {
        return this.PRIME() * seed;
    }

    private boolean isArray(Object anyRef) {
        return anyRef.getClass().isArray();
    }

    private int PRIME() {
        return PRIME;
    }

    private HashCode$() {
    }
}

