/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.guavacommon;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.FutureWrapper;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.common.internal.ValueSourceFuture;

public class GuavaFutureUtils {
    public static <T> ListenableFuture<T> createListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
        if (valueSourceFuture instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSourceFuture).getWrappedFuture();
        }
        return new ValueSourceFutureBackedListenableFuture<T>(valueSourceFuture);
    }

    public static <T> ListenableFuture<T> createListenableFuture(ValueSource<T> valueSource) {
        if (valueSource instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSource).getWrappedFuture();
        }
        return new ValueSourceBackedListenableFuture(valueSource);
    }

    public static <T> ValueSourceFuture<T> createValueSourceFuture(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceFutureBackedListenableFuture) {
            return ((ValueSourceFutureBackedListenableFuture)listenableFuture).getWrappedFuture();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    public static <T> ValueSource<T> createValueSource(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceBackedListenableFuture) {
            return ((ValueSourceBackedListenableFuture)listenableFuture).getValueSource();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    private static class ListenableFutureBackedValueSourceFuture<T>
    extends ValueSourceFuture<T> {
        private ListenableFutureBackedValueSourceFuture(ListenableFuture<T> wrappedFuture) {
            super(wrappedFuture);
        }

        public void addCallbacks(final Consumer<T> successCallback, final Consumer<Throwable> failureCallback) {
            Futures.addCallback(this.getWrappedFuture(), (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    successCallback.accept(result);
                }

                public void onFailure(Throwable t) {
                    failureCallback.accept(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        protected ListenableFuture<T> getWrappedFuture() {
            return (ListenableFuture)super.getWrappedFuture();
        }
    }

    private static class ValueSourceBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        private final ValueSource<T> valueSource;

        private ValueSourceBackedListenableFuture(ValueSource<T> valueSource) {
            super((Future)SettableFuture.create());
            this.valueSource = valueSource;
            valueSource.addCallbacks(value -> this.getWrappedFuture().set(value), ex -> this.getWrappedFuture().setException(ex));
        }

        public void addListener(Runnable listener, Executor executor) {
            this.getWrappedFuture().addListener(listener, executor);
        }

        protected SettableFuture<T> getWrappedFuture() {
            return (SettableFuture)super.getWrappedFuture();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.valueSource.cancel(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }
    }

    private static class ValueSourceFutureBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        ValueSourceFutureBackedListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
            super(valueSourceFuture);
        }

        protected ValueSourceFuture<T> getWrappedFuture() {
            return (ValueSourceFuture)super.getWrappedFuture();
        }

        public void addListener(Runnable listener, Executor executor) {
            this.getWrappedFuture().addCallbacks(value -> executor.execute(listener), ex -> executor.execute(listener));
        }
    }
}

