/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import java.util.Arrays;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class MessageIdData {
    private long ledgerId;
    private static final int _LEDGER_ID_FIELD_NUMBER = 1;
    private static final int _LEDGER_ID_TAG = 8;
    private static final int _LEDGER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _LEDGER_ID_MASK = 1;
    private long entryId;
    private static final int _ENTRY_ID_FIELD_NUMBER = 2;
    private static final int _ENTRY_ID_TAG = 16;
    private static final int _ENTRY_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _ENTRY_ID_MASK = 2;
    private int partition = -1;
    private static final int _PARTITION_FIELD_NUMBER = 3;
    private static final int _PARTITION_TAG = 24;
    private static final int _PARTITION_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _PARTITION_MASK = 4;
    private int batchIndex = -1;
    private static final int _BATCH_INDEX_FIELD_NUMBER = 4;
    private static final int _BATCH_INDEX_TAG = 32;
    private static final int _BATCH_INDEX_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _BATCH_INDEX_MASK = 8;
    private long[] ackSets = null;
    private int _ackSetsCount = 0;
    private static final int _ACK_SET_FIELD_NUMBER = 5;
    private static final int _ACK_SET_TAG = 40;
    private static final int _ACK_SET_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _ACK_SET_TAG_PACKED = 42;
    private int batchSize;
    private static final int _BATCH_SIZE_FIELD_NUMBER = 6;
    private static final int _BATCH_SIZE_TAG = 48;
    private static final int _BATCH_SIZE_TAG_SIZE = LightProtoCodec.computeVarIntSize(48);
    private static final int _BATCH_SIZE_MASK = 32;
    private MessageIdData firstChunkMessageId;
    private static final int _FIRST_CHUNK_MESSAGE_ID_FIELD_NUMBER = 7;
    private static final int _FIRST_CHUNK_MESSAGE_ID_TAG = 58;
    private static final int _FIRST_CHUNK_MESSAGE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private static final int _FIRST_CHUNK_MESSAGE_ID_MASK = 64;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasLedgerId() {
        return (this._bitField0 & 1) != 0;
    }

    public long getLedgerId() {
        if (!this.hasLedgerId()) {
            throw new IllegalStateException("Field 'ledgerId' is not set");
        }
        return this.ledgerId;
    }

    public MessageIdData setLedgerId(long ledgerId) {
        this.ledgerId = ledgerId;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public MessageIdData clearLedgerId() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasEntryId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getEntryId() {
        if (!this.hasEntryId()) {
            throw new IllegalStateException("Field 'entryId' is not set");
        }
        return this.entryId;
    }

    public MessageIdData setEntryId(long entryId) {
        this.entryId = entryId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public MessageIdData clearEntryId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasPartition() {
        return (this._bitField0 & 4) != 0;
    }

    public int getPartition() {
        return this.partition;
    }

    public MessageIdData setPartition(int partition) {
        this.partition = partition;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public MessageIdData clearPartition() {
        this._bitField0 &= 0xFFFFFFFB;
        this.partition = -1;
        return this;
    }

    public boolean hasBatchIndex() {
        return (this._bitField0 & 8) != 0;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public MessageIdData setBatchIndex(int batchIndex) {
        this.batchIndex = batchIndex;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public MessageIdData clearBatchIndex() {
        this._bitField0 &= 0xFFFFFFF7;
        this.batchIndex = -1;
        return this;
    }

    public int getAckSetsCount() {
        return this._ackSetsCount;
    }

    public long getAckSetAt(int idx) {
        if (idx < 0 || idx >= this._ackSetsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._ackSetsCount + ") for field 'ack_set'");
        }
        return this.ackSets[idx];
    }

    public void addAckSet(long ackSet) {
        if (this.ackSets == null) {
            this.ackSets = new long[4];
        }
        if (this.ackSets.length == this._ackSetsCount) {
            this.ackSets = Arrays.copyOf(this.ackSets, this._ackSetsCount * 2);
        }
        this._cachedSize = -1;
        this.ackSets[this._ackSetsCount++] = ackSet;
    }

    public MessageIdData clearAckSet() {
        this._ackSetsCount = 0;
        return this;
    }

    public boolean hasBatchSize() {
        return (this._bitField0 & 0x20) != 0;
    }

    public int getBatchSize() {
        if (!this.hasBatchSize()) {
            throw new IllegalStateException("Field 'batch_size' is not set");
        }
        return this.batchSize;
    }

    public MessageIdData setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        this._bitField0 |= 0x20;
        this._cachedSize = -1;
        return this;
    }

    public MessageIdData clearBatchSize() {
        this._bitField0 &= 0xFFFFFFDF;
        return this;
    }

    public boolean hasFirstChunkMessageId() {
        return (this._bitField0 & 0x40) != 0;
    }

    public MessageIdData getFirstChunkMessageId() {
        if (!this.hasFirstChunkMessageId()) {
            throw new IllegalStateException("Field 'first_chunk_message_id' is not set");
        }
        return this.firstChunkMessageId;
    }

    public MessageIdData setFirstChunkMessageId() {
        if (this.firstChunkMessageId == null) {
            this.firstChunkMessageId = new MessageIdData();
        }
        this._bitField0 |= 0x40;
        this._cachedSize = -1;
        return this.firstChunkMessageId;
    }

    public MessageIdData clearFirstChunkMessageId() {
        this._bitField0 &= 0xFFFFFFBF;
        if (this.hasFirstChunkMessageId()) {
            this.firstChunkMessageId.clear();
        }
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.ledgerId);
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.entryId);
        if (this.hasPartition()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt(_b, this.partition);
        }
        if (this.hasBatchIndex()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt(_b, this.batchIndex);
        }
        for (int i = 0; i < this._ackSetsCount; ++i) {
            long _item = this.ackSets[i];
            LightProtoCodec.writeVarInt(_b, 40);
            LightProtoCodec.writeVarInt64(_b, _item);
        }
        if (this.hasBatchSize()) {
            LightProtoCodec.writeVarInt(_b, 48);
            LightProtoCodec.writeVarInt(_b, this.batchSize);
        }
        if (this.hasFirstChunkMessageId()) {
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, this.firstChunkMessageId.getSerializedSize());
            this.firstChunkMessageId.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _LEDGER_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.ledgerId);
        _size += _ENTRY_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.entryId);
        if (this.hasPartition()) {
            _size += _PARTITION_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.partition);
        }
        if (this.hasBatchIndex()) {
            _size += _BATCH_INDEX_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.batchIndex);
        }
        for (int i = 0; i < this._ackSetsCount; ++i) {
            long _item = this.ackSets[i];
            _size += _ACK_SET_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(_item);
        }
        if (this.hasBatchSize()) {
            _size += _BATCH_SIZE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.batchSize);
        }
        if (this.hasFirstChunkMessageId()) {
            _size += LightProtoCodec.computeVarIntSize(58);
            int MsgsizeFirstChunkMessageId = this.firstChunkMessageId.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeFirstChunkMessageId) + MsgsizeFirstChunkMessageId;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block10: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.ledgerId = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.entryId = LightProtoCodec.readVarInt64(_buffer);
                    continue block10;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.partition = LightProtoCodec.readVarInt(_buffer);
                    continue block10;
                }
                case 32: {
                    this._bitField0 |= 8;
                    this.batchIndex = LightProtoCodec.readVarInt(_buffer);
                    continue block10;
                }
                case 40: {
                    this.addAckSet(LightProtoCodec.readVarInt64(_buffer));
                    continue block10;
                }
                case 48: {
                    this._bitField0 |= 0x20;
                    this.batchSize = LightProtoCodec.readVarInt(_buffer);
                    continue block10;
                }
                case 58: {
                    this._bitField0 |= 0x40;
                    int firstChunkMessageIdSize = LightProtoCodec.readVarInt(_buffer);
                    this.setFirstChunkMessageId().parseFrom(_buffer, firstChunkMessageIdSize);
                    continue block10;
                }
                case 42: {
                    int _ackSetSize = LightProtoCodec.readVarInt(_buffer);
                    int _ackSetEndIdx = _buffer.readerIndex() + _ackSetSize;
                    while (_buffer.readerIndex() < _ackSetEndIdx) {
                        this.addAckSet(LightProtoCodec.readVarInt64(_buffer));
                    }
                    continue block10;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public MessageIdData clear() {
        this.partition = -1;
        this.batchIndex = -1;
        this._ackSetsCount = 0;
        if (this.hasFirstChunkMessageId()) {
            this.firstChunkMessageId.clear();
        }
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public MessageIdData copyFrom(MessageIdData _other) {
        this._cachedSize = -1;
        if (_other.hasLedgerId()) {
            this.setLedgerId(_other.ledgerId);
        }
        if (_other.hasEntryId()) {
            this.setEntryId(_other.entryId);
        }
        if (_other.hasPartition()) {
            this.setPartition(_other.partition);
        }
        if (_other.hasBatchIndex()) {
            this.setBatchIndex(_other.batchIndex);
        }
        for (int i = 0; i < _other.getAckSetsCount(); ++i) {
            this.addAckSet(_other.getAckSetAt(i));
        }
        if (_other.hasBatchSize()) {
            this.setBatchSize(_other.batchSize);
        }
        if (_other.hasFirstChunkMessageId()) {
            this.setFirstChunkMessageId().copyFrom(_other.firstChunkMessageId);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

